/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.enumerator.splitter;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.JdbcDataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.splitter.ChunkRange;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.splitter.JdbcSourceChunkSplitter;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.cdc.base.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcSourceChunkSplitter
implements JdbcSourceChunkSplitter {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcSourceChunkSplitter.class);
    private final JdbcSourceConfig sourceConfig;
    private final JdbcDataSourceDialect dialect;

    public AbstractJdbcSourceChunkSplitter(JdbcSourceConfig sourceConfig, JdbcDataSourceDialect dialect) {
        this.sourceConfig = sourceConfig;
        this.dialect = dialect;
    }

    @Override
    public Collection<SnapshotSplit> generateSplits(TableId tableId) {
        ArrayList<SnapshotSplit> arrayList;
        block14: {
            JdbcConnection jdbc = this.dialect.openJdbcConnection(this.sourceConfig);
            try {
                log.info("Start splitting table {} into chunks...", (Object)tableId);
                long start = System.currentTimeMillis();
                Column splitColumn = this.getSplitColumn(jdbc, this.dialect, tableId);
                ArrayList<SnapshotSplit> splits = new ArrayList<SnapshotSplit>();
                if (splitColumn == null) {
                    if (this.sourceConfig.isExactlyOnce()) {
                        throw new UnsupportedOperationException(String.format("Exactly once is enabled, but not found primary key or unique key for table %s", tableId));
                    }
                    SnapshotSplit singleSplit = this.createSnapshotSplit(jdbc, tableId, 0, null, null, null);
                    splits.add(singleSplit);
                    log.warn("No evenly split column found for table {}, use single split {}", (Object)tableId, (Object)singleSplit);
                } else {
                    List<ChunkRange> chunks;
                    try {
                        chunks = this.splitTableIntoChunks(jdbc, tableId, splitColumn);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to split chunks for table " + tableId, e);
                    }
                    SeaTunnelRowType splitType = this.getSplitType(splitColumn);
                    for (int i = 0; i < chunks.size(); ++i) {
                        ChunkRange chunk = chunks.get(i);
                        SnapshotSplit split = this.createSnapshotSplit(jdbc, tableId, i, splitType, chunk.getChunkStart(), chunk.getChunkEnd());
                        splits.add(split);
                    }
                }
                long end = System.currentTimeMillis();
                log.info("Split table {} into {} chunks, time cost: {}ms.", new Object[]{tableId, splits.size(), end - start});
                arrayList = splits;
                if (jdbc == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbc != null) {
                        try {
                            jdbc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Generate Splits for table %s error", tableId), e);
                }
            }
            jdbc.close();
        }
        return arrayList;
    }

    private List<ChunkRange> splitTableIntoChunks(JdbcConnection jdbc, TableId tableId, Column splitColumn) throws Exception {
        String splitColumnName = splitColumn.name();
        Object[] minMax = this.queryMinMax(jdbc, tableId, splitColumn);
        Object min = minMax[0];
        Object max = minMax[1];
        if (min == null || max == null || min.equals(max)) {
            return Collections.singletonList(ChunkRange.all());
        }
        int chunkSize = this.sourceConfig.getSplitSize();
        double distributionFactorUpper = this.sourceConfig.getDistributionFactorUpper();
        double distributionFactorLower = this.sourceConfig.getDistributionFactorLower();
        int sampleShardingThreshold = this.sourceConfig.getSampleShardingThreshold();
        log.info("Splitting table {} into chunks, split column: {}, min: {}, max: {}, chunk size: {}, distribution factor upper: {}, distribution factor lower: {}, sample sharding threshold: {}", new Object[]{tableId, splitColumnName, min, max, chunkSize, distributionFactorUpper, distributionFactorLower, sampleShardingThreshold});
        if (this.isEvenlySplitColumn(splitColumn)) {
            boolean dataIsEvenlyDistributed;
            long approximateRowCnt = this.queryApproximateRowCnt(jdbc, tableId);
            double distributionFactor = this.calculateDistributionFactor(tableId, min, max, approximateRowCnt);
            boolean bl = dataIsEvenlyDistributed = ObjectUtils.doubleCompare(distributionFactor, distributionFactorLower) >= 0 && ObjectUtils.doubleCompare(distributionFactor, distributionFactorUpper) <= 0;
            if (dataIsEvenlyDistributed) {
                int dynamicChunkSize = Math.max((int)(distributionFactor * (double)chunkSize), 1);
                return this.splitEvenlySizedChunks(tableId, min, max, approximateRowCnt, chunkSize, dynamicChunkSize);
            }
            int shardCount = (int)(approximateRowCnt / (long)chunkSize);
            int inverseSamplingRate = this.sourceConfig.getInverseSamplingRate();
            if (sampleShardingThreshold < shardCount) {
                if (inverseSamplingRate > chunkSize) {
                    log.warn("The inverseSamplingRate is {}, which is greater than chunkSize {}, so we set inverseSamplingRate to chunkSize", (Object)inverseSamplingRate, (Object)chunkSize);
                    inverseSamplingRate = chunkSize;
                }
                log.info("Use sampling sharding for table {}, the sampling rate is {}", (Object)tableId, (Object)inverseSamplingRate);
                Object[] sample = this.sampleDataFromColumn(jdbc, tableId, splitColumn, inverseSamplingRate);
                log.info("Sample data from table {} end, the sample size is {}", (Object)tableId, (Object)sample.length);
                return this.efficientShardingThroughSampling(tableId, sample, approximateRowCnt, shardCount);
            }
            return this.splitUnevenlySizedChunks(jdbc, tableId, splitColumn, min, max, chunkSize);
        }
        return this.splitUnevenlySizedChunks(jdbc, tableId, splitColumn, min, max, chunkSize);
    }

    protected List<ChunkRange> splitUnevenlySizedChunks(JdbcConnection jdbc, TableId tableId, Column splitColumn, Object min, Object max, int chunkSize) throws SQLException {
        log.info("Use unevenly-sized chunks for table {}, the chunk size is {}", (Object)tableId, (Object)chunkSize);
        ArrayList<ChunkRange> splits = new ArrayList<ChunkRange>();
        Object chunkStart = null;
        Object chunkEnd = this.nextChunkEnd(jdbc, min, tableId, splitColumn, max, chunkSize);
        int count = 0;
        while (chunkEnd != null && this.ObjectCompare(chunkEnd, max) <= 0) {
            splits.add(ChunkRange.of(chunkStart, chunkEnd));
            AbstractJdbcSourceChunkSplitter.maySleep(count++, tableId);
            chunkStart = chunkEnd;
            chunkEnd = this.nextChunkEnd(jdbc, chunkEnd, tableId, splitColumn, max, chunkSize);
        }
        splits.add(ChunkRange.of(chunkStart, null));
        return splits;
    }

    protected Object nextChunkEnd(JdbcConnection jdbc, Object previousChunkEnd, TableId tableId, Column splitColumn, Object max, int chunkSize) throws SQLException {
        Object chunkEnd = this.queryNextChunkMax(jdbc, tableId, splitColumn, chunkSize, previousChunkEnd);
        if (Objects.equals(previousChunkEnd, chunkEnd)) {
            chunkEnd = this.queryMin(jdbc, tableId, splitColumn, chunkEnd);
        }
        if (this.ObjectCompare(chunkEnd, max) >= 0) {
            return null;
        }
        return chunkEnd;
    }

    protected List<ChunkRange> efficientShardingThroughSampling(TableId tableId, Object[] sampleData, long approximateRowCnt, int shardCount) {
        log.info("Use efficient sharding through sampling optimization for table {}, the approximate row count is {}, the shardCount is {}", new Object[]{tableId, approximateRowCnt, shardCount});
        ArrayList<ChunkRange> splits = new ArrayList<ChunkRange>();
        if (shardCount == 0) {
            splits.add(ChunkRange.of(null, null));
            return splits;
        }
        double approxSamplePerShard = (double)sampleData.length / (double)shardCount;
        Object lastEnd = null;
        if (approxSamplePerShard <= 1.0) {
            splits.add(ChunkRange.of(null, sampleData[0]));
            lastEnd = sampleData[0];
            for (int i = 1; i < sampleData.length; ++i) {
                if (sampleData[i].equals(lastEnd)) continue;
                splits.add(ChunkRange.of(lastEnd, sampleData[i]));
                lastEnd = sampleData[i];
            }
            splits.add(ChunkRange.of(lastEnd, null));
        } else {
            for (int i = 0; i < shardCount; ++i) {
                Object chunkEnd;
                Object chunkStart = lastEnd;
                Object object = chunkEnd = i < shardCount - 1 ? sampleData[(int)((double)(i + 1) * approxSamplePerShard)] : null;
                if (i != 0 && i != shardCount - 1 && Objects.equals(chunkEnd, chunkStart)) continue;
                splits.add(ChunkRange.of(chunkStart, chunkEnd));
                lastEnd = chunkEnd;
            }
        }
        return splits;
    }

    protected List<ChunkRange> splitEvenlySizedChunks(TableId tableId, Object min, Object max, long approximateRowCnt, int chunkSize, int dynamicChunkSize) {
        log.info("Use evenly-sized chunk optimization for table {}, the approximate row count is {}, the chunk size is {}, the dynamic chunk size is {}", new Object[]{tableId, approximateRowCnt, chunkSize, dynamicChunkSize});
        if (approximateRowCnt <= (long)chunkSize) {
            return Collections.singletonList(ChunkRange.all());
        }
        ArrayList<ChunkRange> splits = new ArrayList<ChunkRange>();
        Object chunkStart = null;
        Object chunkEnd = ObjectUtils.plus(min, dynamicChunkSize);
        while (this.ObjectCompare(chunkEnd, max) <= 0) {
            splits.add(ChunkRange.of(chunkStart, chunkEnd));
            chunkStart = chunkEnd;
            try {
                chunkEnd = ObjectUtils.plus(chunkEnd, dynamicChunkSize);
            }
            catch (ArithmeticException e) {
                // empty catch block
                break;
            }
        }
        splits.add(ChunkRange.of(chunkStart, null));
        return splits;
    }

    protected double calculateDistributionFactor(TableId tableId, Object min, Object max, long approximateRowCnt) {
        if (!min.getClass().equals(max.getClass())) {
            throw new IllegalStateException(String.format("Unsupported operation type, the MIN value type %s is different with MAX value type %s.", min.getClass().getSimpleName(), max.getClass().getSimpleName()));
        }
        if (approximateRowCnt == 0L) {
            return Double.MAX_VALUE;
        }
        BigDecimal difference = ObjectUtils.minus(max, min);
        BigDecimal subRowCnt = difference.add(BigDecimal.valueOf(1L));
        double distributionFactor = subRowCnt.divide(new BigDecimal(approximateRowCnt), 4, 2).doubleValue();
        log.info("The distribution factor of table {} is {} according to the min split key {}, max split key {} and approximate row count {}", new Object[]{tableId, distributionFactor, min, max, approximateRowCnt});
        return distributionFactor;
    }

    protected SnapshotSplit createSnapshotSplit(JdbcConnection jdbc, TableId tableId, int chunkId, SeaTunnelRowType splitKeyType, Object chunkStart, Object chunkEnd) {
        Object[] objectArray;
        Object[] objectArray2;
        if (chunkStart == null) {
            objectArray2 = null;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = chunkStart;
        }
        Object[] splitStart = objectArray2;
        if (chunkEnd == null) {
            objectArray = null;
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = chunkEnd;
        }
        Object[] splitEnd = objectArray;
        return new SnapshotSplit(this.splitId(tableId, chunkId), tableId, splitKeyType, splitStart, splitEnd);
    }

    protected Column getSplitColumn(JdbcConnection jdbc, JdbcDataSourceDialect dialect, TableId tableId) throws SQLException {
        Column splitColumn = null;
        Table table = dialect.queryTableSchema(jdbc, tableId).getTable();
        Map<Object, Object> splitColumnsConfig = new HashMap();
        try {
            splitColumnsConfig = this.sourceConfig.getSplitColumn();
        }
        catch (Exception e) {
            log.error("Config snapshotSplitColumn get exception in {}:{}", (Object)tableId, (Object)e);
        }
        String tableSc = splitColumnsConfig.getOrDefault(tableId.catalog() + "." + tableId.table(), null);
        if (StringUtils.isNotEmpty((CharSequence)tableSc)) {
            AtomicBoolean isUniqueKey = new AtomicBoolean(false);
            dialect.getUniqueKeys(jdbc, tableId).forEach(ck -> ck.getColumnNames().forEach(ckc -> {
                if (tableSc.equals(ckc.getColumnName())) {
                    isUniqueKey.set(true);
                }
            }));
            if (isUniqueKey.get()) {
                Column column = table.columnWithName(tableSc);
                if (this.isEvenlySplitColumn(column)) {
                    return column;
                }
                log.warn("Config snapshotSplitColumn type in {} is not TINYINT\u3001SMALLINT\u3001INT\u3001BIGINT\u3001DECIMAL\u3001STRING", (Object)tableId);
            } else {
                log.warn("Config snapshotSplitColumn not unique key for table {}", (Object)tableId);
            }
        } else {
            log.info("Config snapshotSplitColumn not exists for table {}", (Object)tableId);
        }
        Optional<PrimaryKey> primaryKey = dialect.getPrimaryKey(jdbc, tableId);
        if (primaryKey.isPresent()) {
            List pkColumns = primaryKey.get().getColumnNames();
            for (String pkColumn : pkColumns) {
                Column column = table.columnWithName(pkColumn);
                if (!this.isEvenlySplitColumn(column) || this.sqlTypePriority(splitColumn = this.columnComparable(splitColumn, column)) != 1) continue;
                return splitColumn;
            }
        } else {
            log.warn("No primary key found for table {}", (Object)tableId);
        }
        List<ConstraintKey> uniqueKeys = dialect.getUniqueKeys(jdbc, tableId);
        if (!uniqueKeys.isEmpty()) {
            for (ConstraintKey uniqueKey : uniqueKeys) {
                List uniqueKeyColumns = uniqueKey.getColumnNames();
                for (ConstraintKey.ConstraintKeyColumn uniqueKeyColumn : uniqueKeyColumns) {
                    Column column = table.columnWithName(uniqueKeyColumn.getColumnName());
                    if (!this.isEvenlySplitColumn(column) || this.sqlTypePriority(splitColumn = this.columnComparable(splitColumn, column)) != 1) continue;
                    return splitColumn;
                }
            }
        } else {
            log.warn("No unique key found for table {}", (Object)tableId);
        }
        if (splitColumn != null) {
            return splitColumn;
        }
        log.warn("No evenly split column found for table {}", (Object)tableId);
        return null;
    }

    protected String splitId(TableId tableId, int chunkId) {
        return tableId.toString() + ":" + chunkId;
    }

    protected int ObjectCompare(Object obj1, Object obj2) {
        return ObjectUtils.compare(obj1, obj2);
    }

    private static void maySleep(int count, TableId tableId) {
        if (count % 10 == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("JdbcSourceChunkSplitter has split {} chunks for table {}", (Object)count, (Object)tableId);
        }
    }

    private int sqlTypePriority(Column splitColumn) {
        switch (this.fromDbzColumn(splitColumn).getSqlType()) {
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INT: {
                return 3;
            }
            case BIGINT: {
                return 4;
            }
            case DECIMAL: {
                return 5;
            }
            case STRING: {
                return 6;
            }
        }
        return Integer.MAX_VALUE;
    }

    private Column columnComparable(Column then, Column other) {
        if (then == null) {
            return other;
        }
        if (this.sqlTypePriority(then) > this.sqlTypePriority(other)) {
            return other;
        }
        return then;
    }
}

