/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.config;

import java.io.Serializable;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;

public final class StopConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StopMode stopMode;
    private final String specificOffsetFile;
    private final Long specificOffsetPos;
    private final Long timestamp;

    public Offset getStopOffset(OffsetFactory offsetFactory) {
        switch (this.stopMode) {
            case LATEST: {
                return offsetFactory.latest();
            }
            case NEVER: {
                return offsetFactory.neverStop();
            }
            case SPECIFIC: {
                return offsetFactory.specific(this.specificOffsetFile, this.specificOffsetPos);
            }
            case TIMESTAMP: {
                return offsetFactory.timestamp(this.timestamp);
            }
        }
        throw new IllegalArgumentException(String.format("The %s mode is not supported.", new Object[]{this.stopMode}));
    }

    public StopConfig(StopMode stopMode, String specificOffsetFile, Long specificOffsetPos, Long timestamp) {
        this.stopMode = stopMode;
        this.specificOffsetFile = specificOffsetFile;
        this.specificOffsetPos = specificOffsetPos;
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StopConfig)) {
            return false;
        }
        StopConfig other = (StopConfig)o;
        Long this$specificOffsetPos = this.specificOffsetPos;
        Long other$specificOffsetPos = other.specificOffsetPos;
        if (this$specificOffsetPos == null ? other$specificOffsetPos != null : !((Object)this$specificOffsetPos).equals(other$specificOffsetPos)) {
            return false;
        }
        Long this$timestamp = this.timestamp;
        Long other$timestamp = other.timestamp;
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        StopMode this$stopMode = this.getStopMode();
        StopMode other$stopMode = other.getStopMode();
        if (this$stopMode == null ? other$stopMode != null : !((Object)((Object)this$stopMode)).equals((Object)other$stopMode)) {
            return false;
        }
        String this$specificOffsetFile = this.specificOffsetFile;
        String other$specificOffsetFile = other.specificOffsetFile;
        return !(this$specificOffsetFile == null ? other$specificOffsetFile != null : !this$specificOffsetFile.equals(other$specificOffsetFile));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $specificOffsetPos = this.specificOffsetPos;
        result = result * 59 + ($specificOffsetPos == null ? 43 : ((Object)$specificOffsetPos).hashCode());
        Long $timestamp = this.timestamp;
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        StopMode $stopMode = this.getStopMode();
        result = result * 59 + ($stopMode == null ? 43 : ((Object)((Object)$stopMode)).hashCode());
        String $specificOffsetFile = this.specificOffsetFile;
        result = result * 59 + ($specificOffsetFile == null ? 43 : $specificOffsetFile.hashCode());
        return result;
    }

    public StopMode getStopMode() {
        return this.stopMode;
    }
}

