/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.assertion.rule;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertCatalogTableRule;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertCatalogTableRuleParser;
import org.apache.seatunnel.connectors.seatunnel.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigObject;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertRuleParser {
    private static final Logger log = LoggerFactory.getLogger(AssertRuleParser.class);

    public List<AssertFieldRule.AssertRule> parseRowRules(List<? extends Config> rowRuleList) {
        return this.assembleFieldValueRules(rowRuleList);
    }

    public AssertCatalogTableRule parseCatalogTableRule(Config catalogTableRule) {
        return new AssertCatalogTableRuleParser().parseCatalogTableRule(catalogTableRule);
    }

    public List<AssertFieldRule> parseRules(List<? extends Config> ruleConfigList) {
        return ruleConfigList.stream().map(config -> {
            AssertFieldRule fieldRule = new AssertFieldRule();
            String fieldName = config.getString("field_name");
            fieldRule.setFieldName(config.getString("field_name"));
            if (config.hasPath("field_type")) {
                ConfigValue fieldTypeConf = config.getValue("field_type");
                switch (fieldTypeConf.valueType()) {
                    case STRING: {
                        String basicTypeStr = config.getString("field_type");
                        SeaTunnelDataType fieldType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType((String)fieldName, (String)basicTypeStr);
                        fieldRule.setFieldType(fieldType);
                        break;
                    }
                    case OBJECT: {
                        ConfigObject rowTypeConf = config.getObject("field_type");
                        SeaTunnelDataType fieldType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType((String)fieldName, (String)rowTypeConf.render());
                        fieldRule.setFieldType(fieldType);
                        break;
                    }
                    case BOOLEAN: 
                    case NUMBER: 
                    case LIST: 
                    case NULL: {
                        log.warn(String.format("Assert Field Rule[%s] doesn't support '%s' type value.", "field_type", fieldTypeConf.valueType()));
                    }
                }
            }
            if (config.hasPath("field_value")) {
                List<AssertFieldRule.AssertRule> fieldValueRules = this.assembleFieldValueRules(config.getConfigList("field_value"));
                fieldRule.setFieldRules(fieldValueRules);
            }
            return fieldRule;
        }).collect(Collectors.toList());
    }

    private List<AssertFieldRule.AssertRule> assembleFieldValueRules(List<? extends Config> fieldValueConfigList) {
        return fieldValueConfigList.stream().map(config -> {
            AssertFieldRule.AssertRule valueRule = new AssertFieldRule.AssertRule();
            if (config.hasPath("rule_type")) {
                valueRule.setRuleType(AssertFieldRule.AssertRuleType.valueOf(config.getString("rule_type")));
            }
            if (config.hasPath("rule_value")) {
                valueRule.setRuleValue(config.getDouble("rule_value"));
            }
            if (config.hasPath("equals_to")) {
                valueRule.setEqualTo(config.getValue("equals_to").unwrapped());
            }
            return valueRule;
        }).collect(Collectors.toList());
    }
}

