/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.registration.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.rya.periodic.notification.api.LifeCycle;
import org.apache.rya.periodic.notification.api.NotificationCoordinatorExecutor;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.registration.kafka.PeriodicNotificationConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaNotificationProvider
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaNotificationProvider.class);
    private final String topic;
    private ExecutorService executor;
    private final NotificationCoordinatorExecutor coord;
    private final Properties props;
    private final int numThreads;
    private boolean running = false;
    Deserializer<String> keyDe;
    Deserializer<CommandNotification> valDe;
    List<PeriodicNotificationConsumer> consumers;

    public KafkaNotificationProvider(String topic, Deserializer<String> keyDe, Deserializer<CommandNotification> valDe, Properties props, NotificationCoordinatorExecutor coord, int numThreads) {
        this.coord = coord;
        this.numThreads = numThreads;
        this.topic = topic;
        this.props = props;
        this.consumers = new ArrayList<PeriodicNotificationConsumer>();
        this.keyDe = keyDe;
        this.valDe = valDe;
    }

    public void stop() {
        if (this.consumers != null && this.consumers.size() > 0) {
            for (PeriodicNotificationConsumer consumer : this.consumers) {
                consumer.shutdown();
            }
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.running = false;
        try {
            if (!this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                LOG.info("Timed out waiting for consumer threads to shut down, exiting uncleanly");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted during shutdown, exiting uncleanly");
        }
    }

    public void start() {
        if (!this.running) {
            if (!this.coord.currentlyRunning()) {
                this.coord.start();
            }
            this.executor = Executors.newFixedThreadPool(this.numThreads);
            for (int threadNumber = 0; threadNumber < this.numThreads; ++threadNumber) {
                LOG.info("Creating consumer: {} for Kafka topic: {}", (Object)threadNumber, (Object)this.topic);
                KafkaConsumer consumer = new KafkaConsumer(this.props, this.keyDe, this.valDe);
                PeriodicNotificationConsumer periodicConsumer = new PeriodicNotificationConsumer(this.topic, (KafkaConsumer<String, CommandNotification>)consumer, threadNumber, this.coord);
                this.consumers.add(periodicConsumer);
                this.executor.submit(periodicConsumer);
            }
            this.running = true;
        }
    }

    public boolean currentlyRunning() {
        return this.running;
    }
}

