/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.recovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.scanner.ColumnScanner;
import org.apache.fluo.api.client.scanner.RowScanner;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.ColumnValue;
import org.apache.fluo.api.data.Span;
import org.apache.rya.indexing.pcj.fluo.app.NodeType;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryColumns;
import org.apache.rya.indexing.pcj.fluo.app.query.FluoQueryMetadataDAO;
import org.apache.rya.indexing.pcj.fluo.app.query.PeriodicQueryMetadata;
import org.apache.rya.indexing.pcj.fluo.app.util.FluoQueryUtils;
import org.apache.rya.periodic.notification.api.Notification;
import org.apache.rya.periodic.notification.api.NotificationCoordinatorExecutor;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;

public class PeriodicNotificationProvider {
    private FluoQueryMetadataDAO dao = new FluoQueryMetadataDAO();

    public Collection<CommandNotification> getNotifications(Snapshot sx) {
        HashSet<PeriodicQueryMetadata> periodicMetadata = new HashSet<PeriodicQueryMetadata>();
        RowScanner scanner = sx.scanner().fetch(new Column[]{FluoQueryColumns.PERIODIC_QUERY_NODE_ID}).over(Span.prefix((CharSequence)"PE")).byRow().build();
        for (ColumnScanner colScanner : scanner) {
            Iterator values = colScanner.iterator();
            while (values.hasNext()) {
                PeriodicQueryMetadata metadata = this.dao.readPeriodicQueryMetadata((SnapshotBase)sx, ((ColumnValue)values.next()).getsValue());
                periodicMetadata.add(metadata);
            }
        }
        return this.getCommandNotifications(sx, periodicMetadata);
    }

    public void processRegisteredNotifications(NotificationCoordinatorExecutor coordinator, Snapshot sx) {
        coordinator.start();
        Collection<CommandNotification> notifications = this.getNotifications(sx);
        for (CommandNotification notification : notifications) {
            coordinator.processNextCommandNotification(notification);
        }
    }

    private Collection<CommandNotification> getCommandNotifications(Snapshot sx, Collection<PeriodicQueryMetadata> metadata) {
        HashSet<CommandNotification> notifications = new HashSet<CommandNotification>();
        int i = 1;
        for (PeriodicQueryMetadata meta : metadata) {
            PeriodicNotification periodic = new PeriodicNotification(this.getQueryId(meta.getNodeId(), sx), meta.getPeriod(), TimeUnit.MILLISECONDS, (long)(i * 5000));
            notifications.add(new CommandNotification(CommandNotification.Command.ADD, (Notification)periodic));
            ++i;
        }
        return notifications;
    }

    private String getQueryId(String periodicNodeId, Snapshot sx) {
        return this.getQueryIdFromPeriodicId(sx, periodicNodeId);
    }

    private String getQueryIdFromPeriodicId(Snapshot sx, String nodeId) {
        NodeType nodeType = (NodeType)NodeType.fromNodeId((String)nodeId).orNull();
        String id = null;
        switch (nodeType) {
            case FILTER: {
                id = this.getQueryIdFromPeriodicId(sx, sx.get(Bytes.of((String)nodeId), FluoQueryColumns.FILTER_PARENT_NODE_ID).toString());
                break;
            }
            case PERIODIC_QUERY: {
                id = this.getQueryIdFromPeriodicId(sx, sx.get(Bytes.of((String)nodeId), FluoQueryColumns.PERIODIC_QUERY_PARENT_NODE_ID).toString());
                break;
            }
            case QUERY: {
                id = FluoQueryUtils.convertFluoQueryIdToPcjId((String)nodeId);
                break;
            }
            case AGGREGATION: {
                id = this.getQueryIdFromPeriodicId(sx, sx.get(Bytes.of((String)nodeId), FluoQueryColumns.AGGREGATION_PARENT_NODE_ID).toString());
                break;
            }
            case CONSTRUCT: {
                id = this.getQueryIdFromPeriodicId(sx, sx.get(Bytes.of((String)nodeId), FluoQueryColumns.CONSTRUCT_PARENT_NODE_ID).toString());
                break;
            }
            case PROJECTION: {
                id = this.getQueryIdFromPeriodicId(sx, sx.get(Bytes.of((String)nodeId), FluoQueryColumns.PROJECTION_PARENT_NODE_ID).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        return id;
    }
}

