/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.pruner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.client.FluoClient;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.periodic.notification.api.LifeCycle;
import org.apache.rya.periodic.notification.api.NodeBin;
import org.apache.rya.periodic.notification.pruner.AccumuloBinPruner;
import org.apache.rya.periodic.notification.pruner.FluoBinPruner;
import org.apache.rya.periodic.notification.pruner.PeriodicQueryPruner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicQueryPrunerExecutor
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(PeriodicQueryPrunerExecutor.class);
    private final FluoClient client;
    private final int numThreads;
    private final ExecutorService executor;
    private final BlockingQueue<NodeBin> bins;
    private final PeriodicQueryResultStorage periodicStorage;
    private final List<PeriodicQueryPruner> pruners;
    private boolean running = false;

    public PeriodicQueryPrunerExecutor(PeriodicQueryResultStorage periodicStorage, FluoClient client, int numThreads, BlockingQueue<NodeBin> bins) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0);
        this.periodicStorage = periodicStorage;
        this.numThreads = numThreads;
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.bins = bins;
        this.client = client;
        this.pruners = new ArrayList<PeriodicQueryPruner>();
    }

    public void start() {
        if (!this.running) {
            AccumuloBinPruner accPruner = new AccumuloBinPruner(this.periodicStorage);
            FluoBinPruner fluoPruner = new FluoBinPruner(this.client);
            for (int threadNumber = 0; threadNumber < this.numThreads; ++threadNumber) {
                PeriodicQueryPruner pruner = new PeriodicQueryPruner(fluoPruner, accPruner, this.client, this.bins, threadNumber);
                this.pruners.add(pruner);
                this.executor.submit(pruner);
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.pruners != null && this.pruners.size() > 0) {
            this.pruners.forEach(x -> x.shutdown());
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.running = false;
        }
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.info("Timed out waiting for consumer threads to shut down, exiting uncleanly");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted during shutdown, exiting uncleanly");
        }
    }

    public boolean currentlyRunning() {
        return this.running;
    }
}

