/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.pruner;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.rya.indexing.pcj.fluo.app.NodeType;
import org.apache.rya.indexing.pcj.fluo.app.util.PeriodicQueryUtil;
import org.apache.rya.periodic.notification.api.BinPruner;
import org.apache.rya.periodic.notification.api.NodeBin;
import org.apache.rya.periodic.notification.pruner.AccumuloBinPruner;
import org.apache.rya.periodic.notification.pruner.FluoBinPruner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicQueryPruner
implements BinPruner,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(PeriodicQueryPruner.class);
    private final FluoClient client;
    private final AccumuloBinPruner accPruner;
    private final FluoBinPruner fluoPruner;
    private final BlockingQueue<NodeBin> bins;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int threadNumber;

    public PeriodicQueryPruner(FluoBinPruner fluoPruner, AccumuloBinPruner accPruner, FluoClient client, BlockingQueue<NodeBin> bins, int threadNumber) {
        this.fluoPruner = Objects.requireNonNull(fluoPruner);
        this.accPruner = Objects.requireNonNull(accPruner);
        this.client = Objects.requireNonNull(client);
        this.bins = Objects.requireNonNull(bins);
        this.threadNumber = threadNumber;
    }

    @Override
    public void run() {
        try {
            while (!this.closed.get()) {
                this.pruneBindingSetBin(this.bins.take());
            }
        }
        catch (InterruptedException e) {
            log.warn("Thread {} is unable to prune the next message.", (Object)this.threadNumber);
            throw new RuntimeException(e);
        }
    }

    public void pruneBindingSetBin(NodeBin nodeBin) {
        String pcjId = nodeBin.getNodeId();
        long bin = nodeBin.getBin();
        try (Snapshot sx = this.client.newSnapshot();){
            String queryId = NodeType.generateNewIdForType((NodeType)NodeType.QUERY, (String)pcjId);
            Set<String> fluoIds = this.getNodeIdsFromResultId((SnapshotBase)sx, queryId);
            this.accPruner.pruneBindingSetBin(nodeBin);
            for (String fluoId : fluoIds) {
                this.fluoPruner.pruneBindingSetBin(new NodeBin(fluoId, bin));
            }
        }
        catch (Exception e) {
            log.warn("Could not successfully initialize PeriodicQueryBinPruner.", (Throwable)e);
        }
    }

    public void shutdown() {
        this.closed.set(true);
    }

    private Set<String> getNodeIdsFromResultId(SnapshotBase sx, String id) {
        HashSet<String> ids = new HashSet<String>();
        PeriodicQueryUtil.getPeriodicQueryNodeAncestorIds((SnapshotBase)sx, (String)id, ids);
        return ids;
    }
}

