/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.pruner;

import com.google.common.base.Optional;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.Transaction;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.Span;
import org.apache.rya.indexing.pcj.fluo.app.NodeType;
import org.apache.rya.indexing.pcj.fluo.app.batch.BatchInformation;
import org.apache.rya.indexing.pcj.fluo.app.batch.BatchInformationDAO;
import org.apache.rya.indexing.pcj.fluo.app.batch.SpanBatchDeleteInformation;
import org.apache.rya.indexing.pcj.fluo.app.util.BindingHashShardingFunction;
import org.apache.rya.periodic.notification.api.BinPruner;
import org.apache.rya.periodic.notification.api.NodeBin;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoBinPruner
implements BinPruner {
    private static final Logger log = LoggerFactory.getLogger(FluoBinPruner.class);
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final FluoClient client;

    public FluoBinPruner(FluoClient client) {
        this.client = client;
    }

    public void pruneBindingSetBin(NodeBin nodeBin) {
        String id = nodeBin.getNodeId();
        long bin = nodeBin.getBin();
        try (Transaction tx = this.client.newTransaction();){
            Optional type = NodeType.fromNodeId((String)id);
            if (!type.isPresent()) {
                log.trace("Unable to determine NodeType from id: " + id);
                throw new RuntimeException();
            }
            Column batchInfoColumn = ((NodeType)type.get()).getResultColumn();
            Bytes batchInfoSpanPrefix = BindingHashShardingFunction.getShardedScanPrefix((String)id, (Value)VF.createLiteral(bin));
            SpanBatchDeleteInformation batchInfo = SpanBatchDeleteInformation.builder().setColumn(batchInfoColumn).setSpan(Span.prefix((Bytes)batchInfoSpanPrefix)).build();
            BatchInformationDAO.addBatch((TransactionBase)tx, (String)id, (BatchInformation)batchInfo);
            tx.commit();
        }
    }
}

