/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.pruner;

import java.util.Objects;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryStorageException;
import org.apache.rya.periodic.notification.api.BinPruner;
import org.apache.rya.periodic.notification.api.NodeBin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloBinPruner
implements BinPruner {
    private static final Logger log = LoggerFactory.getLogger(AccumuloBinPruner.class);
    private final PeriodicQueryResultStorage periodicStorage;

    public AccumuloBinPruner(PeriodicQueryResultStorage periodicStorage) {
        this.periodicStorage = Objects.requireNonNull(periodicStorage);
    }

    public void pruneBindingSetBin(NodeBin nodeBin) {
        Objects.requireNonNull(nodeBin);
        String id = nodeBin.getNodeId();
        long bin = nodeBin.getBin();
        try {
            this.periodicStorage.deletePeriodicQueryResults(id, bin);
        }
        catch (PeriodicQueryStorageException e) {
            log.trace("Unable to delete results from Peroidic Table: " + id + " for bin: " + bin);
            throw new RuntimeException(e);
        }
    }
}

