/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.rya.indexing.pcj.storage.PeriodicQueryResultStorage;
import org.apache.rya.periodic.notification.api.BindingSetRecord;
import org.apache.rya.periodic.notification.api.LifeCycle;
import org.apache.rya.periodic.notification.api.NodeBin;
import org.apache.rya.periodic.notification.notification.TimestampedNotification;
import org.apache.rya.periodic.notification.processor.TimestampedNotificationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationProcessorExecutor
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(NotificationProcessorExecutor.class);
    private final BlockingQueue<TimestampedNotification> notifications;
    private final BlockingQueue<NodeBin> bins;
    private final BlockingQueue<BindingSetRecord> bindingSets;
    private final PeriodicQueryResultStorage periodicStorage;
    private final List<TimestampedNotificationProcessor> processors;
    private final int numberThreads;
    private ExecutorService executor;
    private boolean running = false;

    public NotificationProcessorExecutor(PeriodicQueryResultStorage periodicStorage, BlockingQueue<TimestampedNotification> notifications, BlockingQueue<NodeBin> bins, BlockingQueue<BindingSetRecord> bindingSets, int numberThreads) {
        this.notifications = Objects.requireNonNull(notifications);
        this.bins = Objects.requireNonNull(bins);
        this.bindingSets = Objects.requireNonNull(bindingSets);
        this.periodicStorage = periodicStorage;
        this.numberThreads = numberThreads;
        this.processors = new ArrayList<TimestampedNotificationProcessor>();
    }

    public void start() {
        if (!this.running) {
            this.executor = Executors.newFixedThreadPool(this.numberThreads);
            for (int threadNumber = 0; threadNumber < this.numberThreads; ++threadNumber) {
                log.info("Creating processor for thread: {}", (Object)threadNumber);
                TimestampedNotificationProcessor processor = TimestampedNotificationProcessor.builder().setBindingSets(this.bindingSets).setBins(this.bins).setPeriodicStorage(this.periodicStorage).setNotifications(this.notifications).setThreadNumber(threadNumber).build();
                this.processors.add(processor);
                this.executor.submit(processor);
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.processors != null && this.processors.size() > 0) {
            this.processors.forEach(x -> x.shutdown());
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.running = false;
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.info("Timed out waiting for consumer threads to shut down, exiting uncleanly");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted during shutdown, exiting uncleanly");
        }
    }

    public boolean currentlyRunning() {
        return this.running;
    }
}

