/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.exporter;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.rya.periodic.notification.api.BindingSetExporter;
import org.apache.rya.periodic.notification.api.BindingSetRecord;
import org.apache.rya.periodic.notification.api.BindingSetRecordExportException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPeriodicBindingSetExporter
implements BindingSetExporter,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(KafkaPeriodicBindingSetExporter.class);
    private final KafkaProducer<String, BindingSet> producer;
    private final BlockingQueue<BindingSetRecord> bindingSets;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int threadNumber;

    public KafkaPeriodicBindingSetExporter(KafkaProducer<String, BindingSet> producer, int threadNumber, BlockingQueue<BindingSetRecord> bindingSets) {
        this.threadNumber = threadNumber;
        this.producer = Objects.requireNonNull(producer);
        this.bindingSets = Objects.requireNonNull(bindingSets);
    }

    public void exportNotification(BindingSetRecord record) throws BindingSetRecordExportException {
        try {
            log.info("Exporting {} records to Kafka to topic: {}", (Object)record.getBindingSet().size(), (Object)record.getTopic());
            String bindingName = "periodicBinId";
            BindingSet bindingSet = record.getBindingSet();
            String topic = record.getTopic();
            long binId = ((Literal)bindingSet.getValue("periodicBinId")).longValue();
            Future future = this.producer.send(new ProducerRecord(topic, (Object)Long.toString(binId), (Object)bindingSet));
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new BindingSetRecordExportException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            while (!this.closed.get()) {
                this.exportNotification(this.bindingSets.take());
            }
        }
        catch (InterruptedException | BindingSetRecordExportException e) {
            log.warn("Thread " + this.threadNumber + " is unable to process message.", e);
        }
    }

    public void shutdown() {
        this.closed.set(true);
    }
}

