/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.exporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.rya.periodic.notification.api.BindingSetRecord;
import org.apache.rya.periodic.notification.api.LifeCycle;
import org.apache.rya.periodic.notification.exporter.KafkaPeriodicBindingSetExporter;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExporterExecutor
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(KafkaExporterExecutor.class);
    private final KafkaProducer<String, BindingSet> producer;
    private final BlockingQueue<BindingSetRecord> bindingSets;
    private ExecutorService executor;
    private final List<KafkaPeriodicBindingSetExporter> exporters;
    private final int numThreads;
    private boolean running = false;

    public KafkaExporterExecutor(KafkaProducer<String, BindingSet> producer, int numThreads, BlockingQueue<BindingSetRecord> bindingSets) {
        this.producer = Objects.requireNonNull(producer);
        this.bindingSets = Objects.requireNonNull(bindingSets);
        this.numThreads = numThreads;
        this.exporters = new ArrayList<KafkaPeriodicBindingSetExporter>();
    }

    public void start() {
        if (!this.running) {
            this.executor = Executors.newFixedThreadPool(this.numThreads);
            for (int threadNumber = 0; threadNumber < this.numThreads; ++threadNumber) {
                log.info("Creating exporter: {}", (Object)threadNumber);
                KafkaPeriodicBindingSetExporter exporter = new KafkaPeriodicBindingSetExporter(this.producer, threadNumber, this.bindingSets);
                this.exporters.add(exporter);
                this.executor.submit(exporter);
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        if (this.exporters != null && this.exporters.size() > 0) {
            this.exporters.forEach(x -> x.shutdown());
        }
        if (this.producer != null) {
            this.producer.close();
        }
        this.running = false;
        try {
            if (!this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                log.info("Timed out waiting for consumer threads to shut down, exiting uncleanly");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted during shutdown, exiting uncleanly");
        }
    }

    public boolean currentlyRunning() {
        return this.running;
    }
}

