/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.coordinator;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rya.periodic.notification.api.Notification;
import org.apache.rya.periodic.notification.api.NotificationCoordinatorExecutor;
import org.apache.rya.periodic.notification.notification.CommandNotification;
import org.apache.rya.periodic.notification.notification.PeriodicNotification;
import org.apache.rya.periodic.notification.notification.TimestampedNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicNotificationCoordinatorExecutor
implements NotificationCoordinatorExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicNotificationCoordinatorExecutor.class);
    private int numThreads;
    private ScheduledExecutorService producerThreadPool;
    private Map<String, ScheduledFuture<?>> serviceMap = new HashMap();
    private BlockingQueue<TimestampedNotification> notifications;
    private final ReentrantLock lock = new ReentrantLock(true);
    private boolean running = false;

    public PeriodicNotificationCoordinatorExecutor(int numThreads, BlockingQueue<TimestampedNotification> notifications) {
        this.numThreads = numThreads;
        this.notifications = notifications;
    }

    public void processNextCommandNotification(CommandNotification notification) {
        this.lock.lock();
        try {
            this.processNotification(notification);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        if (!this.running) {
            this.producerThreadPool = Executors.newScheduledThreadPool(this.numThreads);
            this.running = true;
        }
    }

    public void stop() {
        if (this.producerThreadPool != null) {
            this.producerThreadPool.shutdown();
        }
        this.running = false;
        try {
            if (!this.producerThreadPool.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                this.producerThreadPool.shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.info("Service Executor Shutdown has been called.  Terminating NotificationRunnable");
        }
    }

    private void processNotification(CommandNotification notification) {
        CommandNotification.Command command = notification.getCommand();
        Notification periodic = notification.getNotification();
        switch (command) {
            case ADD: {
                this.addNotification(periodic);
                break;
            }
            case DELETE: {
                this.deleteNotification(periodic);
            }
        }
    }

    private void addNotification(Notification notification) {
        Preconditions.checkArgument((boolean)(notification instanceof PeriodicNotification));
        PeriodicNotification notify = (PeriodicNotification)notification;
        if (!this.serviceMap.containsKey(notification.getId())) {
            ScheduledFuture<?> future = this.producerThreadPool.scheduleAtFixedRate(new NotificationProducer(notify), notify.getInitialDelay(), notify.getPeriod(), notify.getTimeUnit());
            this.serviceMap.put(notify.getId(), future);
        }
    }

    private boolean deleteNotification(Notification notification) {
        if (this.serviceMap.containsKey(notification.getId())) {
            ScheduledFuture<?> future = this.serviceMap.remove(notification.getId());
            future.cancel(true);
            return true;
        }
        return false;
    }

    public boolean currentlyRunning() {
        return this.running;
    }

    class NotificationProducer
    implements Runnable {
        private PeriodicNotification notification;

        public NotificationProducer(PeriodicNotification notification) {
            this.notification = notification;
        }

        @Override
        public void run() {
            try {
                PeriodicNotificationCoordinatorExecutor.this.notifications.put(new TimestampedNotification(this.notification));
            }
            catch (InterruptedException e) {
                LOG.info("Unable to add notification.  Process interrupted. ");
                throw new RuntimeException(e);
            }
        }
    }
}

