/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.application;

import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;

public class PeriodicNotificationApplicationConfiguration
extends AccumuloRdfConfiguration {
    public static final String RYA_PERIODIC_PREFIX = "rya.periodic.notification.";
    public static final String RYA_PCJ_PREFIX = "rya.pcj.";
    public static final String FLUO_APP_NAME = "rya.pcj.fluo.app.name";
    public static final String FLUO_TABLE_NAME = "rya.pcj.fluo.table.name";
    public static final String KAFKA_BOOTSTRAP_SERVERS = "rya.periodic.notification.kafka.bootstrap.servers";
    public static final String NOTIFICATION_TOPIC = "rya.periodic.notification.kafka.topic";
    public static final String NOTIFICATION_GROUP_ID = "rya.periodic.notification.kafka.group.id";
    public static final String NOTIFICATION_CLIENT_ID = "rya.periodic.notification.kafka.client.id";
    public static final String COORDINATOR_THREADS = "rya.periodic.notification.coordinator.threads";
    public static final String PRODUCER_THREADS = "rya.periodic.notification.producer.threads";
    public static final String EXPORTER_THREADS = "rya.periodic.notification.exporter.threads";
    public static final String PROCESSOR_THREADS = "rya.periodic.notification.processor.threads";
    public static final String PRUNER_THREADS = "rya.periodic.notification.pruner.threads";

    public PeriodicNotificationApplicationConfiguration() {
    }

    public PeriodicNotificationApplicationConfiguration(Properties props) {
        super((Configuration)PeriodicNotificationApplicationConfiguration.fromProperties((Properties)props));
        this.setFluoAppName(props.getProperty(FLUO_APP_NAME));
        this.setFluoTableName(props.getProperty(FLUO_TABLE_NAME));
        this.setBootStrapServers(props.getProperty(KAFKA_BOOTSTRAP_SERVERS));
        this.setNotificationClientId(props.getProperty(NOTIFICATION_CLIENT_ID, "consumer0"));
        this.setNotificationTopic(props.getProperty(NOTIFICATION_TOPIC, "notifications"));
        this.setNotificationGroupId(props.getProperty(NOTIFICATION_GROUP_ID, "group0"));
        this.setProducerThreads(Integer.parseInt(props.getProperty(PRODUCER_THREADS, "1")));
        this.setProcessorThreads(Integer.parseInt(props.getProperty(PROCESSOR_THREADS, "1")));
        this.setExporterThreads(Integer.parseInt(props.getProperty(EXPORTER_THREADS, "1")));
        this.setPrunerThreads(Integer.parseInt(props.getProperty(PRUNER_THREADS, "1")));
        this.setCoordinatorThreads(Integer.parseInt(props.getProperty(COORDINATOR_THREADS, "1")));
    }

    public void setFluoAppName(String fluoAppName) {
        this.set(FLUO_APP_NAME, Objects.requireNonNull(fluoAppName));
    }

    public void setFluoTableName(String fluoTableName) {
        this.set(FLUO_TABLE_NAME, Objects.requireNonNull(fluoTableName));
    }

    public void setBootStrapServers(String bootStrapServers) {
        this.set(KAFKA_BOOTSTRAP_SERVERS, Objects.requireNonNull(bootStrapServers));
    }

    public void setNotificationTopic(String notificationTopic) {
        this.set(NOTIFICATION_TOPIC, Objects.requireNonNull(notificationTopic));
    }

    public void setNotificationGroupId(String notificationGroupId) {
        this.set(NOTIFICATION_GROUP_ID, Objects.requireNonNull(notificationGroupId));
    }

    public void setNotificationClientId(String notificationClientId) {
        this.set(NOTIFICATION_CLIENT_ID, Objects.requireNonNull(notificationClientId));
    }

    public void setCoordinatorThreads(int threads) {
        this.setInt(COORDINATOR_THREADS, threads);
    }

    public void setExporterThreads(int threads) {
        this.setInt(EXPORTER_THREADS, threads);
    }

    public void setProducerThreads(int threads) {
        this.setInt(PRODUCER_THREADS, threads);
    }

    public void setPrunerThreads(int threads) {
        this.setInt(PRUNER_THREADS, threads);
    }

    public void setProcessorThreads(int threads) {
        this.setInt(PROCESSOR_THREADS, threads);
    }

    public String getFluoAppName() {
        return this.get(FLUO_APP_NAME);
    }

    public String getFluoTableName() {
        return this.get(FLUO_TABLE_NAME);
    }

    public String getBootStrapServers() {
        return this.get(KAFKA_BOOTSTRAP_SERVERS);
    }

    public String getNotificationTopic() {
        return this.get(NOTIFICATION_TOPIC, "notifications");
    }

    public String getNotificationGroupId() {
        return this.get(NOTIFICATION_GROUP_ID, "group0");
    }

    public String getNotificationClientId() {
        return this.get(NOTIFICATION_CLIENT_ID, "consumer0");
    }

    public int getCoordinatorThreads() {
        return this.getInt(COORDINATOR_THREADS, 1);
    }

    public int getExporterThreads() {
        return this.getInt(EXPORTER_THREADS, 1);
    }

    public int getProducerThreads() {
        return this.getInt(PRODUCER_THREADS, 1);
    }

    public int getPrunerThreads() {
        return this.getInt(PRUNER_THREADS, 1);
    }

    public int getProcessorThreads() {
        return this.getInt(PROCESSOR_THREADS, 1);
    }
}

