/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.periodic.notification.application;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.rya.periodic.notification.api.LifeCycle;
import org.apache.rya.periodic.notification.api.NotificationCoordinatorExecutor;
import org.apache.rya.periodic.notification.exporter.KafkaExporterExecutor;
import org.apache.rya.periodic.notification.processor.NotificationProcessorExecutor;
import org.apache.rya.periodic.notification.pruner.PeriodicQueryPrunerExecutor;
import org.apache.rya.periodic.notification.registration.kafka.KafkaNotificationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicNotificationApplication
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(PeriodicNotificationApplication.class);
    private final NotificationCoordinatorExecutor coordinator;
    private final KafkaNotificationProvider provider;
    private final PeriodicQueryPrunerExecutor pruner;
    private final NotificationProcessorExecutor processor;
    private final KafkaExporterExecutor exporter;
    private boolean running = false;
    private Optional<CompletableFuture<Void>> finished = Optional.empty();

    public PeriodicNotificationApplication(KafkaNotificationProvider provider, NotificationCoordinatorExecutor coordinator, NotificationProcessorExecutor processor, KafkaExporterExecutor exporter, PeriodicQueryPrunerExecutor pruner) {
        this.provider = (KafkaNotificationProvider)Preconditions.checkNotNull((Object)provider);
        this.coordinator = (NotificationCoordinatorExecutor)Preconditions.checkNotNull((Object)coordinator);
        this.processor = (NotificationProcessorExecutor)Preconditions.checkNotNull((Object)processor);
        this.exporter = (KafkaExporterExecutor)Preconditions.checkNotNull((Object)exporter);
        this.pruner = (PeriodicQueryPrunerExecutor)Preconditions.checkNotNull((Object)pruner);
    }

    public void start() {
        if (!this.running) {
            log.info("Starting PeriodicNotificationApplication.");
            this.coordinator.start();
            this.provider.start();
            this.processor.start();
            this.pruner.start();
            this.exporter.start();
            this.running = true;
            this.finished = Optional.of(new CompletableFuture());
        }
    }

    public void blockUntilFinished() throws ExecutionException, InterruptedException, IllegalStateException {
        if (!this.finished.isPresent()) {
            throw new IllegalStateException("Cannot block if the application has not been started yet");
        }
        this.finished.get().get();
    }

    public void stop() {
        log.info("Stopping PeriodicNotificationApplication.");
        if (!this.finished.isPresent()) {
            throw new IllegalStateException("Cannot stop if the application has not been started yet");
        }
        this.provider.stop();
        this.coordinator.stop();
        this.processor.stop();
        this.pruner.stop();
        this.exporter.stop();
        this.running = false;
        this.finished.get().complete(null);
    }

    public boolean currentlyRunning() {
        return this.running;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PeriodicQueryPrunerExecutor pruner;
        private KafkaNotificationProvider provider;
        private NotificationProcessorExecutor processor;
        private KafkaExporterExecutor exporter;
        private NotificationCoordinatorExecutor coordinator;

        public Builder setPruner(PeriodicQueryPrunerExecutor pruner) {
            this.pruner = pruner;
            return this;
        }

        public Builder setProvider(KafkaNotificationProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder setProcessor(NotificationProcessorExecutor processor) {
            this.processor = processor;
            return this;
        }

        public Builder setExporter(KafkaExporterExecutor exporter) {
            this.exporter = exporter;
            return this;
        }

        public Builder setCoordinator(NotificationCoordinatorExecutor coordinator) {
            this.coordinator = coordinator;
            return this;
        }

        public PeriodicNotificationApplication build() {
            return new PeriodicNotificationApplication(this.provider, this.coordinator, this.processor, this.exporter, this.pruner);
        }
    }
}

