/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.join;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.apache.rya.api.model.visibility.VisibilitySimplifier;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public final class LazyJoiningIterator
implements Iterator<VisibilityBindingSet> {
    private final Side newResultSide;
    private final VisibilityBindingSet newResult;
    private final Iterator<VisibilityBindingSet> joinedResults;

    public LazyJoiningIterator(Side newResultSide, VisibilityBindingSet newResult, Iterator<VisibilityBindingSet> joinedResults) {
        this.newResultSide = Objects.requireNonNull(newResultSide);
        this.newResult = Objects.requireNonNull(newResult);
        this.joinedResults = Objects.requireNonNull(joinedResults);
    }

    @Override
    public boolean hasNext() {
        return this.joinedResults.hasNext();
    }

    @Override
    public VisibilityBindingSet next() {
        String rightVisi;
        String leftVisi;
        MapBindingSet bs = new MapBindingSet();
        for (Object binding : this.newResult) {
            bs.addBinding((Binding)binding);
        }
        VisibilityBindingSet joinResult = this.joinedResults.next();
        for (Binding binding : joinResult) {
            bs.addBinding(binding);
        }
        if (this.newResultSide == Side.LEFT) {
            leftVisi = this.newResult.getVisibility();
            rightVisi = joinResult.getVisibility();
        } else {
            leftVisi = joinResult.getVisibility();
            rightVisi = this.newResult.getVisibility();
        }
        String visibility = VisibilitySimplifier.unionAndSimplify((String)leftVisi, (String)rightVisi);
        return new VisibilityBindingSet((BindingSet)bs, visibility);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported.");
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

