/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AggregationElement;
import org.apache.rya.api.function.aggregation.AggregationFunction;
import org.apache.rya.api.function.aggregation.AggregationState;
import org.apache.rya.api.function.aggregation.AggregationType;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public final class SumFunction
implements AggregationFunction {
    private static final Logger log = LoggerFactory.getLogger(SumFunction.class);
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    @Override
    public void update(AggregationElement aggregation, AggregationState state, VisibilityBindingSet childBindingSet) {
        Preconditions.checkArgument((aggregation.getAggregationType() == AggregationType.SUM ? 1 : 0) != 0, (Object)"The SumFunction only accepts SUM AggregationElements.");
        Objects.requireNonNull(state);
        Objects.requireNonNull(childBindingSet);
        String aggregatedName = aggregation.getAggregatedBindingName();
        if (childBindingSet.hasBinding(aggregatedName)) {
            Literal childLiteral;
            String resultName;
            MapBindingSet result = state.getBindingSet();
            boolean newBinding = !result.hasBinding(resultName = aggregation.getResultBindingName());
            Literal sum = newBinding ? VF.createLiteral(BigInteger.ZERO) : (Literal)state.getBindingSet().getValue(resultName);
            Value childValue = childBindingSet.getValue(aggregatedName);
            if (childValue instanceof Literal && (childLiteral = (Literal)childValue).getDatatype() != null && XMLDatatypeUtil.isNumericDatatype((IRI)childLiteral.getDatatype())) {
                try {
                    sum = MathUtil.compute((Literal)sum, (Literal)childLiteral, (MathExpr.MathOp)MathExpr.MathOp.PLUS);
                }
                catch (ValueExprEvaluationException e) {
                    log.error("A problem was encountered while updating a Sum Aggregation. This binding set will be ignored: " + childBindingSet);
                    return;
                }
            }
            result.addBinding(resultName, (Value)sum);
        }
    }
}

