/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.rya.api.function.aggregation.AggregationElement;
import org.apache.rya.api.function.aggregation.AggregationFunction;
import org.apache.rya.api.function.aggregation.AggregationState;
import org.apache.rya.api.function.aggregation.AggregationType;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public final class CountFunction
implements AggregationFunction {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    @Override
    public void update(AggregationElement aggregation, AggregationState state, VisibilityBindingSet childBindingSet) {
        Preconditions.checkArgument((aggregation.getAggregationType() == AggregationType.COUNT ? 1 : 0) != 0, (Object)"The CountFunction only accepts COUNT AggregationElements.");
        Objects.requireNonNull(state);
        Objects.requireNonNull(childBindingSet);
        String aggregatedName = aggregation.getAggregatedBindingName();
        if (childBindingSet.hasBinding(aggregatedName)) {
            String resultName;
            boolean newBinding;
            MapBindingSet result = state.getBindingSet();
            boolean bl = newBinding = !result.hasBinding(resultName = aggregation.getResultBindingName());
            if (newBinding) {
                result.addBinding(resultName, (Value)VF.createLiteral(BigInteger.ONE));
            } else {
                Literal count = (Literal)result.getValue(resultName);
                BigInteger updatedCount = count.integerValue().add(BigInteger.ONE);
                result.addBinding(resultName, (Value)VF.createLiteral(updatedCount));
            }
        }
    }
}

