/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.api.function.aggregation;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rya.api.function.aggregation.AggregationElement;
import org.apache.rya.api.function.aggregation.AggregationFunction;
import org.apache.rya.api.function.aggregation.AggregationState;
import org.apache.rya.api.function.aggregation.AggregationStateStore;
import org.apache.rya.api.function.aggregation.AggregationType;
import org.apache.rya.api.function.aggregation.AverageFunction;
import org.apache.rya.api.function.aggregation.CountFunction;
import org.apache.rya.api.function.aggregation.MaxFunction;
import org.apache.rya.api.function.aggregation.MinFunction;
import org.apache.rya.api.function.aggregation.SumFunction;
import org.apache.rya.api.model.VisibilityBindingSet;
import org.apache.rya.api.model.visibility.VisibilitySimplifier;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@DefaultAnnotation(value={NonNull.class})
public class AggregationsEvaluator {
    private static final ImmutableMap<AggregationType, AggregationFunction> FUNCTIONS;
    private final AggregationStateStore aggStateStore;
    private final Collection<AggregationElement> aggregations;
    private final List<String> groupByVars;

    public AggregationsEvaluator(AggregationStateStore aggStateStore, Collection<AggregationElement> aggregations, List<String> groupByVars) {
        this.aggStateStore = Objects.requireNonNull(aggStateStore);
        this.aggregations = Objects.requireNonNull(aggregations);
        this.groupByVars = Objects.requireNonNull(groupByVars);
    }

    public static AggregationsEvaluator make(AggregationStateStore aggStateStore, Group aggNode, List<String> groupByVars) {
        Objects.requireNonNull(aggStateStore);
        Objects.requireNonNull(aggNode);
        Objects.requireNonNull(groupByVars);
        ArrayList<AggregationElement> aggregations = new ArrayList<AggregationElement>();
        for (GroupElem groupElem : aggNode.getGroupElements()) {
            AggregateOperator operator = groupElem.getOperator();
            Optional<AggregationType> type = AggregationType.byOperatorClass(operator.getClass());
            if (!type.isPresent()) continue;
            String resultBindingName = groupElem.getName();
            final AtomicReference aggregatedBindingName = new AtomicReference();
            groupElem.visitChildren((QueryModelVisitor)new AbstractQueryModelVisitor<RuntimeException>(){

                public void meet(Var node) {
                    aggregatedBindingName.set(node.getName());
                }
            });
            aggregations.add(new AggregationElement(type.get(), (String)aggregatedBindingName.get(), resultBindingName));
        }
        return new AggregationsEvaluator(aggStateStore, aggregations, groupByVars);
    }

    public VisibilityBindingSet update(VisibilityBindingSet newBs) {
        Objects.requireNonNull(newBs);
        AggregationState state = this.aggStateStore.get(newBs).orElseGet(() -> {
            AggregationState newState = new AggregationState();
            MapBindingSet bindingSet = newState.getBindingSet();
            for (String groupByVar : this.groupByVars) {
                bindingSet.addBinding(newBs.getBinding(groupByVar));
            }
            return newState;
        });
        String oldVisibility = state.getVisibility();
        String updateVisibilities = VisibilitySimplifier.unionAndSimplify((String)oldVisibility, (String)newBs.getVisibility());
        state.setVisibility(updateVisibilities);
        for (AggregationElement aggregation : this.aggregations) {
            AggregationType type = aggregation.getAggregationType();
            AggregationFunction function = (AggregationFunction)FUNCTIONS.get((Object)type);
            if (function == null) {
                throw new RuntimeException("Unrecognized aggregation function: " + (Object)((Object)type));
            }
            function.update(aggregation, state, newBs);
        }
        this.aggStateStore.store(state);
        return new VisibilityBindingSet((BindingSet)state.getBindingSet(), state.getVisibility());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)AggregationType.COUNT, (Object)new CountFunction());
        builder.put((Object)AggregationType.SUM, (Object)new SumFunction());
        builder.put((Object)AggregationType.AVERAGE, (Object)new AverageFunction());
        builder.put((Object)AggregationType.MIN, (Object)new MinFunction());
        builder.put((Object)AggregationType.MAX, (Object)new MaxFunction());
        FUNCTIONS = builder.build();
    }
}

