/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/utils/getMembersWithNameMatch.as
 * org.apache.royale.reflection.utils.getMembersWithNameMatch
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.utils.getMembersWithNameMatch');

goog.require('org.apache.royale.reflection.MemberDefinitionBase');
goog.require('org.apache.royale.utils.Language');



/**
 *  A utility method to retrieve all members with a name that matches via the matcher argument
 *  
 *  @asparam memberCollection the collection (an Array) of member definitions to check
 *  @asparam matcher *must be* either a String or a Regexp instance to use for testing
 *  @asparam collate an optional array to collate into, if passed externally
 *  @asparam includeCustomNamespaces set to true if you wish to include members with custom namespaces. defaults to false.
 *  
 *  @asreturns an Array (the collate parameter if it was used, otherwise a new Array)
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  
 *  @royaleignorecoercion RegExp
 * @export
 * @param {Array} memberCollection
 * @param {Object=} matcher
 * @param {Array=} collate
 * @param {boolean=} includeCustomNamespaces
 * @return {Array}
 */
org.apache.royale.reflection.utils.getMembersWithNameMatch = function(memberCollection, matcher, collate, includeCustomNamespaces) {
  matcher = typeof matcher !== 'undefined' ? matcher : null;
  collate = typeof collate !== 'undefined' ? collate : null;
  includeCustomNamespaces = typeof includeCustomNamespaces !== 'undefined' ? includeCustomNamespaces : false;
  var /** @type {Array} */ ret = collate ? collate : [];
  var /** @type {RegExp} */ regexp;
  if (org.apache.royale.utils.Language.is(matcher, String)) {
    regexp = new RegExp('^' + matcher + '$');
  } else {
    regexp = matcher;
  }
  if (memberCollection) {
    var foreachiter0_target = memberCollection;
    for (var foreachiter0 in foreachiter0_target) 
    {
    var item = foreachiter0_target[foreachiter0];
    {
      if (item.uri && !includeCustomNamespaces)
        continue;
      if (!regexp || regexp.test(item.name))
        ret.push(item);
    }}
    
  }
  return ret;
}