/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/getDynamicFields.as
 * org.apache.royale.reflection.getDynamicFields
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.getDynamicFields');

goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.reflection.CompilationData');
goog.require('org.apache.royale.reflection.isDynamicObject');
goog.require('org.apache.royale.utils.Language');



/**
 *  A utility method to check if an object is dynamic (i.e. can have non-sealed members added or deleted)
 *  Note that static class objects are always dynamic, as are (static) Interface Objects
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *
 * @asparam inspect the class or instance to check for dynamic fields
 * @asparam includePredicate an optional function for which takes a single String argument
 *          and returns true to include that specific field in the results. If it returns false,
 *          that property is excluded. Defaults to null, which applies no filtering and returns all
 *          detected properties.
 * @asparam checkFirst an optional check to verify that the inspect parameter is dynamic
 *        before inspecting it for dynamic properties. This should normally be left at its default value of true.
 *        If it is known that the object is dynamic before calling this method, setting this to false
 *        could improve performance in performance-sensitive code.
 *        The results of calling this method on non-dynamic objects may be less reliable or less consistent
 *        across target platforms if checkFirst is false
 * @asparam numericFields if true, numeric fields will be returned as numeric values
 *
 * @asreturn the dynamic fields as Strings in an Array
 *
 * @royaleignorecoercion Map
 * @export
 * @param {Object} inspect
 * @param {Function=} includePredicate
 * @param {boolean=} checkFirst
 * @param {boolean=} numericFields
 * @return {Array}
 */
org.apache.royale.reflection.getDynamicFields = function(inspect, includePredicate, checkFirst, numericFields) {
  includePredicate = typeof includePredicate !== 'undefined' ? includePredicate : null;
  checkFirst = typeof checkFirst !== 'undefined' ? checkFirst : true;
  numericFields = typeof numericFields !== 'undefined' ? numericFields : false;
  var /** @type {Array} */ arr;
  var /** @type {number} */ i = 0;
  var /** @type {boolean} */ assumeDynamic = checkFirst ? org.apache.royale.reflection.isDynamicObject(inspect) : true;
  var /** @type {boolean} */ checkIncludes = includePredicate != null;
  var /** @type {string} */ prop;
  if (assumeDynamic) {
    var /** @type {Object} */ constructor = inspect.constructor;
    if (constructor === Object['constructor']) {
      arr = Object.keys(inspect);
      if (inspect.prototype && inspect.prototype.ROYALE_REFLECTION_INFO) {
        if (goog.DEBUG) {
          if (!org.apache.royale.reflection.CompilationData.hasCompilationOption((inspect.prototype.ROYALE_COMPILE_FLAGS) >>> 0, org.apache.royale.reflection.CompilationData.WITH_DEFAULT_INITIALIZERS)) {
            org.apache.royale.utils.Language.trace('[WARN] getDynamicFields can be unreliable for static inspection of ' + inspect.prototype.ROYALE_CLASS_INFO.names[0].qName + ' because it was not compiled with \'js-default-initializers=true\'');
          }
        }
        var /** @type {Array} */ avoidNames = inspect.prototype.ROYALE_INITIAL_STATICS;
        if (avoidNames) {
          var /** @type {Array} */ temp = [];
          var /** @type {number} */ l = (arr.length) >>> 0;
          for (i = 0; i < l; i++) {
            prop = org.apache.royale.utils.Language.string(arr[i]);
            if (avoidNames.indexOf(prop) == -1) {
              temp.push(prop);
            }
          }
          arr = temp;
        }
      }
    } else {
      var /** @type {Array} */ excludeFields;
      arr = Object.keys(inspect);
      var /** @type {boolean} */ warned;
      if (inspect.ROYALE_REFLECTION_INFO) {
        
/**
 * @const
 * @type {Object}
 */
var inspectReflect = inspect.ROYALE_REFLECTION_INFO;
        if (goog.DEBUG) {
          if (!org.apache.royale.reflection.CompilationData.hasCompilationOption((inspect.ROYALE_COMPILE_FLAGS) >>> 0, org.apache.royale.reflection.CompilationData.WITH_DEFAULT_INITIALIZERS)) {
            org.apache.royale.utils.Language.trace('[WARN] getDynamicFields can be unreliable for ' + inspect.ROYALE_CLASS_INFO.names[0].qName + ' and any ancestor classes that were not compiled with \'js-default-initializers=true\'');
            warned = true;
          }
        }
        var /** @type {Array} */ instanceExcludes = inspectReflect.instanceExcludes;
        if (!instanceExcludes) {
          var /** @type {Object} */ eventDispatcherClassInfo;
          if (org.apache.royale.utils.Language.is(inspect, org.apache.royale.events.EventDispatcher)) {
            instanceExcludes = org.apache.royale.reflection.getDynamicFields['EventDispatcherFields'];
            if (!instanceExcludes) {
              var /** @type {Object} */ test = new org.apache.royale.events.EventDispatcher();
              instanceExcludes = org.apache.royale.reflection.getDynamicFields['EventDispatcherFields'] = Object.keys(test);
            }
            
/**
 * @const
 * @type {Object}
 */
var edc = org.apache.royale.events.EventDispatcher;
            eventDispatcherClassInfo = edc.prototype.ROYALE_CLASS_INFO;
          }
          if (!instanceExcludes)
            instanceExcludes = [];
          var /** @type {Object} */ proto = inspect.constructor.prototype;
          while (proto) {
            var /** @type {Object} */ protoReflect = proto.ROYALE_REFLECTION_INFO;
            if (goog.DEBUG && !warned) {
              if (protoReflect && !org.apache.royale.reflection.CompilationData.hasCompilationOption((proto.ROYALE_COMPILE_FLAGS) >>> 0, org.apache.royale.reflection.CompilationData.WITH_DEFAULT_INITIALIZERS)) {
                if (proto.ROYALE_CLASS_INFO.names[0].qName != eventDispatcherClassInfo.names[0].qName) {
                  org.apache.royale.utils.Language.trace('[WARN] getDynamicFields can be unreliable for ' + inspect.ROYALE_CLASS_INFO.names[0].qName + '\'s ancestor class ' + proto.ROYALE_CLASS_INFO.names[0].qName + ' and any of its ancestors that were not compiled with \'js-default-initializers=true\'');
                  warned = true;
                }
              }
            }
            var /** @type {Array} */ inherited = proto.ROYALE_REFLECTION_INFO ? proto.ROYALE_REFLECTION_INFO.instanceExcludes : null;
            var /** @type {Array} */ protoKeys = inherited || Object.keys(proto);
            l = (protoKeys.length) >>> 0;
            while (l--) {
              var /** @type {string} */ key = org.apache.royale.utils.Language.string(protoKeys[l]);
              if (instanceExcludes.indexOf(key) == -1)
                instanceExcludes.push(key);
            }
            if (inherited)
              break;
            proto = proto.constructor.superClass_;
          }
          inspectReflect.instanceExcludes = instanceExcludes;
        }
        l = (instanceExcludes.length) >>> 0;
        if (l && !excludeFields)
          excludeFields = [];
        while (l--) {
          excludeFields.push(instanceExcludes[l]);
        }
      } else {
        if (inspect.constructor == Map) {
          arr = [];
          inspect.forEach(function(value, key, inst) {
            arr.push(key);
          });
        }
      }
      if (excludeFields) {
        l = (excludeFields.length) >>> 0;
        while (l--) {
          var /** @type {number} */ idx = (arr.indexOf(excludeFields[l])) >> 0;
          if (idx != -1) {
            arr.splice(idx, 1);
          }
        }
      }
    }
    if (checkIncludes) {
      arr = arr.filter(includePredicate);
    }
    if (numericFields) {
      arr.forEach(function(value, index, array) {
        var /** @type {number} */ numVal = Number(value);
        if ('' + numVal == value)
          array[index] = numVal;
      });
    }
  } else {
    arr = [];
  }
  return arr;
}