/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/MethodDefinition.as
 * org.apache.royale.reflection.MethodDefinition
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.MethodDefinition');

goog.require('QName');
goog.require('org.apache.royale.reflection.MemberDefinitionBase');
goog.require('org.apache.royale.reflection.ParameterDefinition');
goog.require('org.apache.royale.reflection.TypeDefinition');
goog.require('org.apache.royale.reflection.getDefinitionByName');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.reflection.MemberDefinitionBase}
 * @param {string} name
 * @param {boolean} isStatic
 * @param {org.apache.royale.reflection.TypeDefinition} owner
 * @param {Object=} rawData
 */
org.apache.royale.reflection.MethodDefinition = function(name, isStatic, owner, rawData) {
  rawData = typeof rawData !== 'undefined' ? rawData : null;
  org.apache.royale.reflection.MethodDefinition.base(this, 'constructor', name, isStatic, owner, rawData);
};
goog.inherits(org.apache.royale.reflection.MethodDefinition, org.apache.royale.reflection.MemberDefinitionBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.reflection.MethodDefinition', org.apache.royale.reflection.MethodDefinition);


/**
 * @private
 * @type {Array}
 */
org.apache.royale.reflection.MethodDefinition.prototype.org_apache_royale_reflection_MethodDefinition__parameters;


/**
 * Provides easy access to the method described by this definition
 * For instance member definitions it requires the instance to be passed as a single argument
 * For static member definitions it requires no argument
 *
 * @asparam inst an instance of this definition's owner class - required argument if this definition is for instance scope
 *
 * @asreturn a function reference to the method that this definition describes
 * @export
 * @param {Object=} inst
 * @return {Function}
 */
org.apache.royale.reflection.MethodDefinition.prototype.getMethod = function(inst) {
  inst = typeof inst !== 'undefined' ? inst : null;
  
  var /** @type {string} */ methodName = this.name;
  var /** @type {string} */ closureName = methodName;
  if (this.uri) {
    closureName = this.uri + '::' + methodName;
    methodName = QName.getAsObjectAccessFormat(this.uri, methodName);
  }
  
/**
 * @const
 * @type {Object}
 */
var clazz = org.apache.royale.reflection.getDefinitionByName(this.owner.qualifiedName);
  if (this.isStatic) {
    return clazz[methodName];
  } else {
    if (!inst || !org.apache.royale.utils.Language.is(inst, clazz))
      throw new Error('getMethod argument for instance MethodDefinition must be an instance of ' + this.owner.qualifiedName);
    
    return org.apache.royale.utils.Language.closure(inst[methodName], inst, closureName);
  }
};


/**
 * A string representation of this method definition
 * @export
 * @return {string}
 */
org.apache.royale.reflection.MethodDefinition.prototype.toString = function() {
  var /** @type {number} */ i = 0;
  var /** @type {string} */ retType = this.returnType.qualifiedName;
  if (retType == "")
    retType = "''";
  var /** @type {string} */ uriNS = this.uri;
  if (uriNS)
    uriNS = ', uri=\'' + uriNS + '\'';
  var /** @type {string} */ s = "method: '" + this.name + "'" + uriNS + ", returnType:" + retType + " declaredBy:" + this.declaredBy.qualifiedName;
  var /** @type {Array} */ params = this.parameters;
  //var /** @type {number} */ i = 0;
  var /** @type {number} */ l = (params.length) >>> 0;
  if (!l)
    s += "\n\t{No parameters}";
  else
    for (i = 0; i < l; i++) {
      s += "\n\t" + params[i].toString();
    }
  var /** @type {Array} */ meta = this.metadata;
  l = (meta.length) >>> 0;
  if (l) {
    s += "\n\tmetadata:";
    for (i = 0; i < l; i++) {
      s += "\n\t\t" + meta[i].toString().split("\n").join("\n\t\t");
    }
  }
  return s;
};


org.apache.royale.reflection.MethodDefinition.prototype.get__declaredBy = function() {
  
  var /** @type {string} */ declareBy = org.apache.royale.utils.Language.string(this._rawData.declaredBy);
  return org.apache.royale.reflection.TypeDefinition.internalGetDefinition(declareBy);
};


org.apache.royale.reflection.MethodDefinition.prototype.get__parameters = function() {
  var /** @type {Array} */ results;
  if (this.org_apache_royale_reflection_MethodDefinition__parameters) {
    results = this.org_apache_royale_reflection_MethodDefinition__parameters.slice();
    if (!org.apache.royale.reflection.TypeDefinition["useCache"])
      this.org_apache_royale_reflection_MethodDefinition__parameters = null;
    return results;
  }
  results = [];
  
  if (this.rawData.parameters != null) {
    var /** @type {Array} */ data = this.rawData.parameters();
    var /** @type {number} */ n = (data.length) >> 0;
    for (var /** @type {number} */ i = 0; i < n; i += 2) {
      var /** @type {number} */ index = ((i * .5) + 1) >>> 0;
      var /** @type {Object} */ item = {type:data[i], optional:data[i + 1], index:index};
      results.push(new org.apache.royale.reflection.ParameterDefinition(index, item));
    }
  }
  if (org.apache.royale.reflection.TypeDefinition["useCache"])
    this.org_apache_royale_reflection_MethodDefinition__parameters = results;
  return results;
};


org.apache.royale.reflection.MethodDefinition.prototype.get__returnType = function() {
  
  var /** @type {string} */ returnType = org.apache.royale.utils.Language.string(this._rawData.type);
  return org.apache.royale.reflection.TypeDefinition.internalGetDefinition(returnType);
};


Object.defineProperties(org.apache.royale.reflection.MethodDefinition.prototype, /** @lends {org.apache.royale.reflection.MethodDefinition.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.reflection.TypeDefinition} */
declaredBy: {
get: org.apache.royale.reflection.MethodDefinition.prototype.get__declaredBy},
/**
  * @export
  * @type {Array} */
parameters: {
get: org.apache.royale.reflection.MethodDefinition.prototype.get__parameters},
/**
  * @export
  * @type {org.apache.royale.reflection.TypeDefinition} */
returnType: {
get: org.apache.royale.reflection.MethodDefinition.prototype.get__returnType}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.reflection.MethodDefinition.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'MethodDefinition', qName: 'org.apache.royale.reflection.MethodDefinition', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.reflection.MethodDefinition.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'declaredBy': { type: 'org.apache.royale.reflection.TypeDefinition', access: 'readonly', declaredBy: 'org.apache.royale.reflection.MethodDefinition'},
        'parameters': { type: 'Array', access: 'readonly', declaredBy: 'org.apache.royale.reflection.MethodDefinition'},
        'returnType': { type: 'org.apache.royale.reflection.TypeDefinition', access: 'readonly', declaredBy: 'org.apache.royale.reflection.MethodDefinition'}
      };
    },
    methods: function () {
      return {
        'MethodDefinition': { type: '', declaredBy: 'org.apache.royale.reflection.MethodDefinition', parameters: function () { return [ 'String', false ,'Boolean', false ,'org.apache.royale.reflection.TypeDefinition', false ,'Object', true ]; }},
        'getMethod': { type: 'Function', declaredBy: 'org.apache.royale.reflection.MethodDefinition', parameters: function () { return [ 'Object', true ]; }},
        'toString': { type: 'String', declaredBy: 'org.apache.royale.reflection.MethodDefinition'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.reflection.MethodDefinition.prototype.ROYALE_COMPILE_FLAGS = 10;