/**
 * Generated by Apache Royale Compiler from QName.as
 * QName
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('QName');

goog.require('Namespace');



/**
 * @royaleignorecoercion Namespace
 * @royaleignorecoercion QName
 * @constructor
 * @param {*=} qNameOrUri
 * @param {*=} localNameVal
 */
QName = function(qNameOrUri, localNameVal) {
  qNameOrUri = typeof qNameOrUri !== 'undefined' ? qNameOrUri : undefined;
  localNameVal = typeof localNameVal !== 'undefined' ? localNameVal : undefined;
  
/**
 * @const
 * @type {*}
 */
var firstClass = qNameOrUri && (typeof(qNameOrUri) == 'object') && qNameOrUri['className'];
  
/**
 * @const
 * @type {Namespace}
 */
var ns = (firstClass == 'Namespace') ? qNameOrUri : null;
  
/**
 * @const
 * @type {QName}
 */
var qname = localNameVal && typeof(localNameVal) == 'object' && localNameVal['className'] == 'QName' ? localNameVal : (!ns && firstClass == 'QName') ? qNameOrUri : null;
  if (qname) {
    this.QName__localName = qname.QName__localName;
    if (!ns) {
      if (qname != qNameOrUri) {
        if (firstClass == 'QName') {
          this.QName__uri = qNameOrUri.QName__uri;
        } else {
          if (qNameOrUri === undefined) {
            this.QName__uri = qname.QName__uri;
          } else {
            if (qNameOrUri !== null) {
              this.QName__uri = qNameOrUri.toString();
            } else {
              this.QName__uri = null;
            }
          }
        }
      }
      else
        this.QName__uri = qname.QName__uri;
    } else {
      this.QName__uri = ns.uri;
    }
  } else {
    if (ns) {
      if (localNameVal == undefined)
        this.QName__localName = localNameVal === undefined ? '' : 'null';
      else
        this.QName__localName = localNameVal.toString();
      this.QName__uri = ns.uri;
    } else {
      if (localNameVal !== undefined) {
        this.QName__localName = org.apache.royale.utils.Language.string(localNameVal === null ? 'null' : localNameVal.toString());
        if (qNameOrUri !== undefined) {
          if (qNameOrUri !== null)
            this.QName__uri = qNameOrUri.toString();
        } else {
          if (this.QName__localName == '*')
            this.QName__uri = null;
          else
            this.QName__uri = QName.defaultNS;
        }
      } else {
        if (qNameOrUri !== undefined) {
          this.QName__localName = org.apache.royale.utils.Language.string(qNameOrUri === null ? 'null' : qNameOrUri.toString());
          if (this.QName__localName == '*')
            this.QName__uri = null;
          else
            this.QName__uri = QName.defaultNS;
        } else {
          this.QName__localName = '';
          this.QName__uri = QName.defaultNS;
        }
      }
    }
  }
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('QName', QName);


/**
 * @type {string}
 */
QName.defaultNS = '';


/**
 * @asprivate
 * @royalesuppressexport
 * compiler use only to support QName == QName
 * this method can be dead-code eliminated in release build (by default) if never used
 * @param {QName} lhs
 * @param {QName} rhs
 * @return {boolean}
 */
QName.equality = function(lhs, rhs) {
  return !!(lhs === rhs || (lhs && lhs.equals(rhs)));
};


/**
 * @asprivate
 * @royalesuppressexport
 * compiler-use-only to support new QName with alternate default namespace
 * this method can be dead-code eliminated in release build (by default) if never used
 * @param {*} uri
 * @param {*} arg1
 * @param {*} arg2
 * @return {QName}
 */
QName.createWithDefaultNamespace = function(uri, arg1, arg2) {
  QName.defaultNS = org.apache.royale.utils.Language.string(typeof(uri) == 'string' ? uri : uri.toString());
  var /** @type {QName} */ qName = new QName(arg1, arg2);
  QName.defaultNS = '';
  return qName;
};


/**
 * @asprivate
 * @royalesuppressexport
 * Intended primarily for reflection and other framework use, without the need to construct
 * a QName instance
 * @param {string} uri
 * @param {string} localName
 * @return {string}
 */
QName.getAsObjectAccessFormat = function(uri, localName) {
  var /** @type {string} */ uriVal = uri;
  if (uriVal) {
    uriVal = uriVal.replace(/:/g, "_");
    uriVal = uriVal.replace(/\./g, "_");
    uriVal = uriVal.replace(/\//g, "$");
    return uriVal + "__" + localName;
  }
  return localName;
};


/**
 * @private
 * @type {*}
 */
QName.prototype.QName__uri;


/**
 * @private
 * @type {string}
 */
QName.prototype.QName__localName;


/**
 * @private
 * @type {string}
 */
QName.prototype.QName__prefix;


/**
 * @asprivate
 * @royalesuppressexport
 * intended for internal use only
 * @param {string} value
 */
QName.prototype.setPrefix = function(value) {
  this.QName__prefix = value;
};


/**
 * @export
 * @return {string}
 */
QName.prototype.objectAccessFormat = function() {
  return QName.getAsObjectAccessFormat(org.apache.royale.utils.Language.string(this.QName__uri), this.QName__localName);
};


/**
 * @export
 * @param {QName} name
 * @return {boolean}
 */
QName.prototype.equals = function(name) {
  return name != null && (name === this || (this.uri == name.uri && this.localName == name.localName));
};


/**
 * @export
 * @param {QName} qname
 * @return {boolean}
 */
QName.prototype.matches = function(qname) {
  if (qname && (this.isAttribute != qname.isAttribute))
    return false;
  
/**
 * @const
 * @type {boolean}
 */
var anyName = this.QName__localName == '*';
  if (anyName && (this.QName__uri === null || (qname && this.QName__uri === undefined)))
    return true;
  if (!qname)
    return false;
  if (!anyName && qname && (this.QName__localName != qname.QName__localName))
    return false;
  if (this.QName__uri == null)
    return true;
  return this.QName__uri === qname.QName__uri && this.QName__localName === qname.QName__localName;
};


/**
 * @private
 * @type {boolean}
 */
QName.prototype.QName__isAttribute = false;


/**
 * @asprivate
 * @royalesuppressexport
 * intended for internal use only
 * @param {boolean} value
 */
QName.prototype.setIsAttribute = function(value) {
  this.QName__isAttribute = value;
};


/**
 * @export
 * @param {Array=} namespaces
 * @return {Namespace}
 */
QName.prototype.getNamespace = function(namespaces) {
  namespaces = typeof namespaces !== 'undefined' ? namespaces : null;
  var /** @type {number} */ i = 0;
  //var /** @type {number} */ i = 0;
  var /** @type {Namespace} */ possibleMatch;
  if (!namespaces)
    namespaces = [];
  for (i = 0; i < namespaces.length; i++) {
    if (namespaces[i].uri == this.QName__uri) {
      if (!possibleMatch)
        possibleMatch = namespaces[i];
      if (this.QName__prefix == null)
        return namespaces[i];
    }
  }
  if (possibleMatch)
    return possibleMatch;
  if (!this.QName__prefix)
    return new Namespace(this.QName__uri);
  return new Namespace(this.QName__prefix, this.QName__uri);
};


/**
 * @export
 * @return {string}
 */
QName.prototype.toString = function() {
  if (this.QName__uri !== '') {
    return (this.QName__uri ? this.QName__uri : '*') + "::" + this.QName__localName;
  }
  return this.QName__localName;
};


QName.prototype.get__uri = function() {
  return org.apache.royale.utils.Language.string(this.QName__uri == null ? null : this.QName__uri);
};


QName.prototype.get__localName = function() {
  return this.QName__localName;
};


QName.prototype.get__prefix = function() {
  return this.QName__prefix;
};


QName.prototype.get__className = function() {
  return 'QName';
};


QName.prototype.get__isAttribute = function() {
  return this.QName__isAttribute;
};


Object.defineProperties(QName.prototype, /** @lends {QName.prototype} */ {
/**
  * @export
  * @type {string} */
uri: {
get: QName.prototype.get__uri},
/**
  * @export
  * @type {string} */
localName: {
get: QName.prototype.get__localName},
/**
  * @export
  * @type {string} */
prefix: {
get: QName.prototype.get__prefix},
/**
  * @type {string} */
className: {
get: QName.prototype.get__className},
/**
  * @type {boolean} */
isAttribute: {
get: QName.prototype.get__isAttribute}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
QName.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'QName', qName: 'QName', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
QName.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'uri': { type: 'String', access: 'readonly', declaredBy: 'QName'},
        'localName': { type: 'String', access: 'readonly', declaredBy: 'QName'},
        'prefix': { type: 'String', access: 'readonly', declaredBy: 'QName'}
      };
    },
    methods: function () {
      return {
        'QName': { type: '', declaredBy: 'QName', parameters: function () { return [ '*', true ,'*', true ]; }},
        'objectAccessFormat': { type: 'String', declaredBy: 'QName'},
        'equals': { type: 'Boolean', declaredBy: 'QName', parameters: function () { return [ 'QName', false ]; }},
        'matches': { type: 'Boolean', declaredBy: 'QName', parameters: function () { return [ 'QName', false ]; }},
        'getNamespace': { type: 'Namespace', declaredBy: 'QName', parameters: function () { return [ 'Array', true ]; }},
        'toString': { type: 'String', declaredBy: 'QName'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
QName.prototype.ROYALE_COMPILE_FLAGS = 10;