/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/validators/StringValidator.as
 * org.apache.royale.jewel.beads.validators.StringValidator
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.validators.StringValidator');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.beads.validators.Validator');
goog.require('org.apache.royale.jewel.supportClasses.textinput.TextInputBase');
goog.require('org.apache.royale.utils.OSUtils');
goog.require('org.apache.royale.utils.StringUtil');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.beads.validators.Validator}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.jewel.beads.validators.StringValidator = function() {
  org.apache.royale.jewel.beads.validators.StringValidator.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.validators.StringValidator, org.apache.royale.jewel.beads.validators.Validator);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.validators.StringValidator', org.apache.royale.jewel.beads.validators.StringValidator);


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.org_apache_royale_jewel_beads_validators_StringValidator__autoTrim;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.org_apache_royale_jewel_beads_validators_StringValidator__maxLength = 0;


/**
 * solves Android issue where you can enter more characters than maxlenght in the input
 * @private
 * @param {goog.events.BrowserEvent} event
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.org_apache_royale_jewel_beads_validators_StringValidator_forceMaxLength = function(event) {
  var /** @type {HTMLInputElement} */ input = org.apache.royale.utils.Language.as(this.hostComponent.element, HTMLInputElement);
  if (input.value.length > this.org_apache_royale_jewel_beads_validators_StringValidator__maxLength) {
    input.value = input.value.substring(0, this.org_apache_royale_jewel_beads_validators_StringValidator__maxLength);
  }
};


/**
 *  Override of the base class validate() method to validate a String.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @override
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.validate = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  var /** @type {org.apache.royale.jewel.supportClasses.textinput.TextInputBase} */ txt = org.apache.royale.utils.Language.as(this.hostComponent, org.apache.royale.jewel.supportClasses.textinput.TextInputBase);
  var /** @type {string} */ str = txt.text;
  if (this.autoTrim) {
    str = org.apache.royale.utils.StringUtil.trim(str);
    if (str != txt.text)
      txt.text = str;
  }
  if (org.apache.royale.jewel.beads.validators.StringValidator.superClass_.validate.apply(this, [ event] )) {
    if (str.length < this.required) {
      this.createErrorTip(this.requiredFieldError);
    } else {
      this.destroyErrorTip();
    }
  }
  return !this.isError;
};


/**
 * @private
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.org_apache_royale_jewel_beads_validators_StringValidator_updateHost = function() {
  if (this.hostComponent) {
    if (this.maxLength > 0) {
      this.hostComponent.element.setAttribute('maxlength', this.maxLength);
    } else {
      this.hostComponent.element.removeAttribute('maxlength');
    }
    if (org.apache.royale.utils.OSUtils.getOS() == org.apache.royale.utils.OSUtils.ANDROID_OS) {
      if (this.maxLength > 0) {
        this.hostComponent.element.addEventListener("keyup", org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_validators_StringValidator_forceMaxLength, this, 'org_apache_royale_jewel_beads_validators_StringValidator_forceMaxLength'), false);
      } else {
        this.hostComponent.element.removeEventListener("keyup", org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_validators_StringValidator_forceMaxLength, this, 'org_apache_royale_jewel_beads_validators_StringValidator_forceMaxLength'), false);
      }
    }
  }
};


org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__strand = function(value) {
  org.apache.royale.jewel.beads.validators.StringValidator.superClass_.set__strand.apply(this, [ value] );
  this.org_apache_royale_jewel_beads_validators_StringValidator_updateHost();
};


org.apache.royale.jewel.beads.validators.StringValidator.prototype.get__autoTrim = function() {
  return this.org_apache_royale_jewel_beads_validators_StringValidator__autoTrim;
};


org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__autoTrim = function(value) {
  this.org_apache_royale_jewel_beads_validators_StringValidator__autoTrim = value;
};


org.apache.royale.jewel.beads.validators.StringValidator.prototype.get__maxLength = function() {
  return this.org_apache_royale_jewel_beads_validators_StringValidator__maxLength;
};


org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__maxLength = function(value) {
  this.org_apache_royale_jewel_beads_validators_StringValidator__maxLength = value;
  this.org_apache_royale_jewel_beads_validators_StringValidator_updateHost();
};


Object.defineProperties(org.apache.royale.jewel.beads.validators.StringValidator.prototype, /** @lends {org.apache.royale.jewel.beads.validators.StringValidator.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__strand},
/**
  * @export
  * @type {boolean} */
autoTrim: {
get: org.apache.royale.jewel.beads.validators.StringValidator.prototype.get__autoTrim,
set: org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__autoTrim},
/**
  * @export
  * @type {number} */
maxLength: {
get: org.apache.royale.jewel.beads.validators.StringValidator.prototype.get__maxLength,
set: org.apache.royale.jewel.beads.validators.StringValidator.prototype.set__maxLength}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'StringValidator', qName: 'org.apache.royale.jewel.beads.validators.StringValidator', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.validators.StringValidator'},
        'autoTrim': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.StringValidator'},
        'maxLength': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.StringValidator'}
      };
    },
    methods: function () {
      return {
        'StringValidator': { type: '', declaredBy: 'org.apache.royale.jewel.beads.validators.StringValidator'},
        'validate': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.validators.StringValidator', parameters: function () { return [ 'org.apache.royale.events.Event', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.validators.StringValidator.prototype.ROYALE_COMPILE_FLAGS = 10;