/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/validators/FormValidator.as
 * org.apache.royale.jewel.beads.validators.FormValidator
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.validators.FormValidator');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.Group');
goog.require('org.apache.royale.jewel.Snackbar');
goog.require('org.apache.royale.jewel.beads.validators.Validator');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.beads.validators.Validator}
 */
org.apache.royale.jewel.beads.validators.FormValidator = function() {
  org.apache.royale.jewel.beads.validators.FormValidator.base(this, 'constructor');
  org.apache.royale.jewel.beads.validators.FormValidator.superClass_.set__requiredFieldError.apply(this, [ null] );
};
goog.inherits(org.apache.royale.jewel.beads.validators.FormValidator, org.apache.royale.jewel.beads.validators.Validator);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.validators.FormValidator', org.apache.royale.jewel.beads.validators.FormValidator);


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.org_apache_royale_jewel_beads_validators_FormValidator__isError;


/**
 *  Override of the base class validate() method to call all validators in the form.
 *  dispatch invalid/valid event when validation fails/succeeds.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @override
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.validate = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  this.org_apache_royale_jewel_beads_validators_FormValidator__isError = false;
  this.iterateAll(org.apache.royale.utils.Language.as(this.hostComponent, org.apache.royale.jewel.Group), true);
  if (this.isError) {
    if (this.requiredFieldError)
      org.apache.royale.jewel.Snackbar.show(this.requiredFieldError);
    this.hostComponent.dispatchEvent(new org.apache.royale.events.Event("invalid"));
  } else {
    this.hostComponent.dispatchEvent(new org.apache.royale.events.Event("valid"));
  }
  return !this.isError;
};


/**
 * @protected
 * @param {org.apache.royale.jewel.Group} group
 * @param {boolean} validateAction
 * @param {boolean=} visibleOnly
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.iterateAll = function(group, validateAction, visibleOnly) {
  visibleOnly = typeof visibleOnly !== 'undefined' ? visibleOnly : true;
  for (var /** @type {number} */ i = 0; i < group.numElements; i++) {
    var /** @type {org.apache.royale.core.UIBase} */ child = org.apache.royale.utils.Language.as(group.getElementAt(i), org.apache.royale.core.UIBase);
    if (visibleOnly && !child.visible)
      continue;
    var /** @type {org.apache.royale.jewel.beads.validators.Validator} */ validator = org.apache.royale.utils.Language.as(child.getBeadByType(org.apache.royale.jewel.beads.validators.Validator), org.apache.royale.jewel.beads.validators.Validator);
    if (validator) {
      if (validator == this) {
        if (!validateAction)
          this.destroyErrorTip();
      } else {
        if (org.apache.royale.utils.Language.is(validator, org.apache.royale.jewel.beads.validators.FormValidator)) {
          if (validateAction) {
            if (!validator.validate()) {
              this.org_apache_royale_jewel_beads_validators_FormValidator__isError = true;
            }
          } else {
            org.apache.royale.utils.Language.as(validator, org.apache.royale.jewel.beads.validators.FormValidator, true).removeAllErrorTips();
          }
          continue;
        }
        if (validateAction) {
          if (!validator.validate()) {
            this.org_apache_royale_jewel_beads_validators_FormValidator__isError = true;
          }
        } else {
          validator.destroyErrorTip();
        }
      }
    }
    if (org.apache.royale.utils.Language.is(child, org.apache.royale.jewel.Group)) {
      this.iterateAll(org.apache.royale.utils.Language.as(child, org.apache.royale.jewel.Group), validateAction, visibleOnly);
    }
  }
};


/**
 *  Utility function to remove all error tips below an upper level which defaults
 *  to the host of this FormValidator bead. If an explicit group is passed as the upper
 *  level to iterate from, it should by convention be some child in the hierarchy below
 *  the host of this FormValidator bead, but that requirement is not enforced.
 *
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 *
 *  @royaleignorecoercion org.apache.royale.jewel.Group
 * @export
 * @param {Object=} below
 * @param {boolean=} onlyVisible
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.removeAllErrorTips = function(below, onlyVisible) {
  below = typeof below !== 'undefined' ? below : null;
  onlyVisible = typeof onlyVisible !== 'undefined' ? onlyVisible : false;
  if (!below)
    below = this.hostComponent;
  if (below == this.hostComponent) {
    this.destroyErrorTip();
  }
  this.iterateAll(below, false, onlyVisible);
};


org.apache.royale.jewel.beads.validators.FormValidator.prototype.set__strand = function(value) {
  this.hostComponent = org.apache.royale.utils.Language.as(value, org.apache.royale.core.UIBase);
};


org.apache.royale.jewel.beads.validators.FormValidator.prototype.get__isError = function() {
  return this.org_apache_royale_jewel_beads_validators_FormValidator__isError;
};


Object.defineProperties(org.apache.royale.jewel.beads.validators.FormValidator.prototype, /** @lends {org.apache.royale.jewel.beads.validators.FormValidator.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.validators.FormValidator.prototype.set__strand},
/**
  * @export
  * @type {boolean} */
isError: {
get: org.apache.royale.jewel.beads.validators.FormValidator.prototype.get__isError}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'FormValidator', qName: 'org.apache.royale.jewel.beads.validators.FormValidator', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.validators.FormValidator'},
        'isError': { type: 'Boolean', access: 'readonly', declaredBy: 'org.apache.royale.jewel.beads.validators.FormValidator'}
      };
    },
    methods: function () {
      return {
        'FormValidator': { type: '', declaredBy: 'org.apache.royale.jewel.beads.validators.FormValidator'},
        'validate': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.validators.FormValidator', parameters: function () { return [ 'org.apache.royale.events.Event', true ]; }},
        'removeAllErrorTips': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.validators.FormValidator', parameters: function () { return [ 'org.apache.royale.jewel.Group', true ,'Boolean', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.validators.FormValidator.prototype.ROYALE_COMPILE_FLAGS = 10;