/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/validators/EmailValidator.as
 * org.apache.royale.jewel.beads.validators.EmailValidator
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.validators.EmailValidator');

goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.beads.validators.StringValidator');
goog.require('org.apache.royale.jewel.beads.validators.removeErrorTip');
goog.require('org.apache.royale.jewel.supportClasses.textinput.TextInputBase');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.beads.validators.StringValidator}
 */
org.apache.royale.jewel.beads.validators.EmailValidator = function() {
  org.apache.royale.jewel.beads.validators.EmailValidator.base(this, 'constructor');
};
goog.inherits(org.apache.royale.jewel.beads.validators.EmailValidator, org.apache.royale.jewel.beads.validators.StringValidator);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.validators.EmailValidator', org.apache.royale.jewel.beads.validators.EmailValidator);


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.DISALLOWED_LOCALNAME_CHARS = "()<>,;:\\\"[] `~!#$%^&*={}|/?\t\n\r";


/**
 * @private
 * @const
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.DISALLOWED_DOMAIN_CHARS = "()<>,;:\\\"[] `~!#$%^&*+={}|/?'\t\n\r";


/**
 * Validate a given IP address
 *
 * If IP domain, then must follow [x.x.x.x] format
 * or for IPv6, then follow [x:x:x:x:x:x:x:x] or [x::x:x:x] or some
 * IPv4 hybrid, like [::x.x.x.x] or [0:00::192.168.0.1]
 *
 * @asprivate
 * @private
 * @param {string} ipAddr
 * @return {boolean}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.isValidIPAddress = function(ipAddr) {
  var /** @type {number} */ i = 0;
  var /** @type {number} */ n = 0;
  var /** @type {Array} */ ipArray = [];
  var /** @type {number} */ pos = 0;
  var /** @type {number} */ newpos = 0;
  var /** @type {number} */ item;
  //var /** @type {number} */ n = 0;
  //var /** @type {number} */ i = 0;
  if (ipAddr.indexOf(":") != -1) {
    var /** @type {boolean} */ hasUnlimitedZeros = ipAddr.indexOf("::") != -1;
    if (hasUnlimitedZeros) {
      ipAddr = ipAddr.replace(/^::/, "");
      ipAddr = ipAddr.replace(/::/g, ":");
    }
    while (true) {
      newpos = (ipAddr.indexOf(":", pos)) >> 0;
      if (newpos != -1) {
        ipArray.push(ipAddr.substring(pos, newpos));
      } else {
        ipArray.push(ipAddr.substring(pos));
        break;
      }
      pos = (newpos + 1) >> 0;
    }
    n = (ipArray.length) >> 0;
    
/**
 * @const
 * @type {boolean}
 */
var lastIsV4 = ipArray[n - 1].indexOf(".") != -1;
    if (lastIsV4) {
      if ((ipArray.length != 7 && !hasUnlimitedZeros) || (ipArray.length > 7))
        return false;
      for (i = 0; i < n; i++) {
        if (i == n - 1) {
          return org.apache.royale.jewel.beads.validators.EmailValidator.isValidIPAddress(org.apache.royale.utils.Language.string(ipArray[i]));
        }
        item = parseInt(ipArray[i], 16);
        if (item != 0)
          return false;
      }
    } else {
      if ((ipArray.length != 8 && !hasUnlimitedZeros) || (ipArray.length > 8))
        return false;
      for (i = 0; i < n; i++) {
        item = parseInt(ipArray[i], 16);
        if (isNaN(item) || item < 0 || item > 0xFFFF || ipArray[i] == "")
          return false;
      }
    }
    return true;
  }
  if (ipAddr.indexOf(".") != -1) {
    while (true) {
      newpos = (ipAddr.indexOf(".", pos)) >> 0;
      if (newpos != -1) {
        ipArray.push(ipAddr.substring(pos, newpos));
      } else {
        ipArray.push(ipAddr.substring(pos));
        break;
      }
      pos = (newpos + 1) >> 0;
    }
    if (ipArray.length != 4)
      return false;
    n = (ipArray.length) >> 0;
    for (i = 0; i < n; i++) {
      item = Number(ipArray[i]);
      if (isNaN(item) || item < 0 || item > 255 || ipArray[i] == "")
        return false;
    }
    return true;
  }
  return false;
};


/**
 * @export
 * @param {Object} value
 * @return {Array}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.validateEmail = function(value) {
  var /** @type {number} */ i = 0;
  var /** @type {number} */ n = 0;
  var /** @type {Array} */ results = [];
  var /** @type {string} */ emailStr = String(value);
  var /** @type {string} */ username = "";
  var /** @type {string} */ domain = "";
  //var /** @type {number} */ n = 0;
  //var /** @type {number} */ i = 0;
  var /** @type {number} */ ampPos = (emailStr.indexOf("@")) >> 0;
  if (ampPos == -1) {
    results.push("missingAtSign");
    return results;
  } else if (emailStr.indexOf("@", ampPos + 1) != -1) {
    results.push("tooManyAtSigns");
    return results;
  }
  username = emailStr.substring(0, ampPos);
  domain = emailStr.substring(ampPos + 1);
  var /** @type {number} */ usernameLen = (username.length) >> 0;
  if (usernameLen == 0) {
    results.push("missingUsername");
    return results;
  }
  for (i = 0; i < usernameLen; i++) {
    if (org.apache.royale.jewel.beads.validators.EmailValidator.DISALLOWED_LOCALNAME_CHARS.indexOf(username.charAt(i)) != -1) {
      results.push("invalidChar");
      return results;
    }
  }
  if (username.charAt(0) == '.') {
    results.push("invalidChar");
    return results;
  }
  var /** @type {number} */ domainLen = (domain.length) >> 0;
  if (domainLen == 0) {
    results.push("missingDomain");
    return results;
  }
  if ((domain.charAt(0) == "[") && (domain.charAt(domainLen - 1) == "]")) {
    if (!org.apache.royale.jewel.beads.validators.EmailValidator.isValidIPAddress(domain.substring(1, domainLen - 1))) {
      results.push("invalidIPDomain");
      return results;
    }
  } else {
    var /** @type {number} */ periodPos = (domain.indexOf(".")) >> 0;
    var /** @type {number} */ nextPeriodPos = 0;
    var /** @type {string} */ lastDomain = "";
    if (periodPos == -1) {
      results.push("missingPeriodInDomain");
      return results;
    }
    while (true) {
      nextPeriodPos = (domain.indexOf(".", periodPos + 1)) >> 0;
      if (nextPeriodPos == -1) {
        lastDomain = domain.substring(periodPos + 1);
        if (lastDomain.length == 0) {
          results.push("invalidDomain");
          return results;
        }
        break;
      } else if (nextPeriodPos == periodPos + 1) {
        results.push("invalidPeriodsInDomain");
        return results;
      }
      periodPos = nextPeriodPos;
    }
    for (i = 0; i < domainLen; i++) {
      if (org.apache.royale.jewel.beads.validators.EmailValidator.DISALLOWED_DOMAIN_CHARS.indexOf(domain.charAt(i)) != -1) {
        results.push("invalidChar");
        return results;
      }
    }
    if (domain.charAt(0) == "." || domain.charAt(0) == "-" || domain.charAt(periodPos - 1) == "-") {
      results.push("invalidDomain");
      return results;
    }
  }
  return results;
};


/**
 * @private
 * @type {string}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.org_apache_royale_jewel_beads_validators_EmailValidator__invalidEmailError = 'Email is not valid';


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.org_apache_royale_jewel_beads_validators_EmailValidator__disabled = false;


/**
 *  Override of the base class validate() method to validate a the host textinput as email.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @override
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.validate = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  if (this.org_apache_royale_jewel_beads_validators_EmailValidator__disabled)
    return true;
  if (org.apache.royale.jewel.beads.validators.EmailValidator.superClass_.validate.apply(this, [ event] )) {
    var /** @type {org.apache.royale.jewel.supportClasses.textinput.TextInputBase} */ txt = org.apache.royale.utils.Language.as(this.hostComponent, org.apache.royale.jewel.supportClasses.textinput.TextInputBase);
    var /** @type {string} */ str = txt.text;
    
/**
 * @const
 * @type {boolean}
 */
var performCheck = str.length > 0;
    if (performCheck) {
      
/**
 * @const
 * @type {Array}
 */
var errors = org.apache.royale.jewel.beads.validators.EmailValidator.validateEmail(str);
      if (errors.length) {
        this.createErrorTip(this.invalidEmailError);
      } else {
        this.destroyErrorTip();
      }
    }
  }
  return !this.isError;
};


org.apache.royale.jewel.beads.validators.EmailValidator.prototype.get__invalidEmailError = function() {
  return this.org_apache_royale_jewel_beads_validators_EmailValidator__invalidEmailError;
};


org.apache.royale.jewel.beads.validators.EmailValidator.prototype.set__invalidEmailError = function(value) {
  this.org_apache_royale_jewel_beads_validators_EmailValidator__invalidEmailError = value;
};


org.apache.royale.jewel.beads.validators.EmailValidator.prototype.get__disabled = function() {
  return this.org_apache_royale_jewel_beads_validators_EmailValidator__disabled;
};


org.apache.royale.jewel.beads.validators.EmailValidator.prototype.set__disabled = function(value) {
  if (value != this.org_apache_royale_jewel_beads_validators_EmailValidator__disabled) {
    this.org_apache_royale_jewel_beads_validators_EmailValidator__disabled = value;
    if (value) {
      org.apache.royale.jewel.beads.validators.removeErrorTip(this);
    }
  }
};


Object.defineProperties(org.apache.royale.jewel.beads.validators.EmailValidator.prototype, /** @lends {org.apache.royale.jewel.beads.validators.EmailValidator.prototype} */ {
/**
  * @export
  * @type {string} */
invalidEmailError: {
get: org.apache.royale.jewel.beads.validators.EmailValidator.prototype.get__invalidEmailError,
set: org.apache.royale.jewel.beads.validators.EmailValidator.prototype.set__invalidEmailError},
/**
  * @export
  * @type {boolean} */
disabled: {
get: org.apache.royale.jewel.beads.validators.EmailValidator.prototype.get__disabled,
set: org.apache.royale.jewel.beads.validators.EmailValidator.prototype.set__disabled}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'EmailValidator', qName: 'org.apache.royale.jewel.beads.validators.EmailValidator', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'invalidEmailError': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.EmailValidator'},
        'disabled': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.validators.EmailValidator'}
      };
    },
    methods: function () {
      return {
        '|validateEmail': { type: 'Array', declaredBy: 'org.apache.royale.jewel.beads.validators.EmailValidator', parameters: function () { return [ 'Object', false ]; }},
        'EmailValidator': { type: '', declaredBy: 'org.apache.royale.jewel.beads.validators.EmailValidator'},
        'validate': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.beads.validators.EmailValidator', parameters: function () { return [ 'org.apache.royale.events.Event', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.validators.EmailValidator.prototype.ROYALE_COMPILE_FLAGS = 10;