/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controls/textinput/SearchFilterForList.as
 * org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.KeyboardEvent');
goog.require('org.apache.royale.events.ValueChangeEvent');
goog.require('org.apache.royale.html.util.getLabelFromData');
goog.require('org.apache.royale.jewel.List');
goog.require('org.apache.royale.jewel.itemRenderers.ListItemRenderer');
goog.require('org.apache.royale.jewel.supportClasses.textinput.TextInputBase');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.6
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList = function() {// Compiler generated Binding support implementation:
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.base(this, 'constructor');


this.filterFunction_ = org.apache.royale.utils.Language.closure(this.defaultFilterFunction, this, 'defaultFilterFunction');
};
// Compiler generated Binding support implementation:
goog.inherits(org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList);


/**
 * @private
 * @type {org.apache.royale.jewel.List}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__list;


/**
 * @export
 * @type {Function}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.filterFunction_;


/**
 * @export
 * @type {boolean}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.useDecoration_ = true;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__length = 0;


/**
 * @protected
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype._strand;


/**
 * @protected
 * @param {org.apache.royale.events.KeyboardEvent} event
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.keyUpHandler = function(event) {

/**
 * @const
 * @type {org.apache.royale.jewel.supportClasses.textinput.TextInputBase}
 */
var inputBase = org.apache.royale.utils.Language.as(event.target, org.apache.royale.jewel.supportClasses.textinput.TextInputBase);
if (!inputBase) {
  return;
}
this.keyUpLogic(inputBase);
};


/**
 * @protected
 * @param {Object} input
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.keyUpLogic = function(input) {
if (this.list.selectedIndex != -1) {
  this.list.selectedItem = null;
}
this.applyFilter(org.apache.royale.utils.Language.string(input.text));
};


/**
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.onBeadsAdded = function(event) {
var /** @type {org.apache.royale.jewel.supportClasses.textinput.TextInputBase} */ input = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.jewel.supportClasses.textinput.TextInputBase, true);
input.element.addEventListener('focus', org.apache.royale.utils.Language.closure(this.onInputFocus, this, 'onInputFocus'));
};


/**
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.onInputFocus = function(event) {
this.applyFilter(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.jewel.supportClasses.textinput.TextInputBase, true).text);
};


/**
 * default filter function just filters substrings
 * you can use other advanced methods like levenshtein distance
 *
 * @asparam text, the text where perform the seach
 * @asparam filterText, the text to use as Filter
 * @asreturn true if filterText was found in text, false otherwise
 * @protected
 * @param {string} text
 * @param {string} filterText
 * @return {boolean}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.defaultFilterFunction = function(text, filterText) {
return text.toUpperCase().indexOf(filterText.toUpperCase()) > -1;
};


/**
 * Used to decorated the filtered text
 * 
 * @asparam originalString, the original String
 * @asparam toReplace, the string to replace
 * @asparam decoration, the decoration to use, defaults to "strong"
 * @asreturn the originalString with the replacement performed
 * @protected
 * @param {string} originalString
 * @param {number} location
 * @param {number} len
 * @param {string=} decorationPrefix
 * @param {string=} decorationSufix
 * @return {string}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.decorateText = function(originalString, location, len, decorationPrefix, decorationSufix) {
decorationPrefix = typeof decorationPrefix !== 'undefined' ? decorationPrefix : "<span style='font-weight:bold; text-decoration: underline'>";
decorationSufix = typeof decorationSufix !== 'undefined' ? decorationSufix : "</span>";
var /** @type {string} */ str = originalString.substr(location, len);
return originalString.replace(str, decorationPrefix + str + decorationSufix);
};


/**
 * @protected
 * @param {string} filterText
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.applyFilter = function(filterText) {
var /** @type {org.apache.royale.jewel.itemRenderers.ListItemRenderer} */ ir;
var /** @type {number} */ numElements = this.list.numElements;
var /** @type {Object} */ item = null;
this.length = numElements;
while (numElements--) {
  ir = org.apache.royale.utils.Language.as(this.list.getElementAt(numElements), org.apache.royale.jewel.itemRenderers.ListItemRenderer);
  var /** @type {string} */ textData = org.apache.royale.html.util.getLabelFromData(ir, ir.data);
  if (this.filterFunction(textData, filterText)) {
    ir.visible = true;
    if (textData.toUpperCase() == filterText.toUpperCase()) {
      item = ir.data;
    }
    if (this.useDecoration) {
      ir.text = "<span>" + (filterText != "" ? this.decorateText(textData, (textData.toUpperCase().indexOf(filterText.toUpperCase())) >> 0, (filterText.length) >> 0) : textData) + "</span>";
    }
  } else {
    ir.visible = false;
    this.length--;
  }
}
if (item != null) {
  this.list.selectedItem = item;
}
};Object.defineProperties(org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype, /** @lends {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype} */ {
/** @export
  * @type {Function} */
filterFunction: {
/** @this {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList} */
get: function() {
return this.filterFunction_;
},

/** @this {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList} */
set: function(value) {
if (value != this.filterFunction_) {
    var oldValue = this.filterFunction_;
    this.filterFunction_ = value;
    this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(
         this, "filterFunction", oldValue, value));
}
}},/** @export
  * @type {boolean} */
useDecoration: {
/** @this {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList} */
get: function() {
return this.useDecoration_;
},

/** @this {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList} */
set: function(value) {
if (value != this.useDecoration_) {
    var oldValue = this.useDecoration_;
    this.useDecoration_ = value;
    this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(
         this, "useDecoration", oldValue, value));
}
}}}
);


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.get__list = function() {
return this.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__list;
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.bindable__set__list_org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList = function(value) {
this.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__list = value;
if (this.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__list != null) {
  this.length = this.list.numElements;
}
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__list = function(value) {
var oldValue = this.get__list();
if (oldValue != value) {
this.bindable__set__list_org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList(value);
    this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(
         this, "list", oldValue, value));
}
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.get__length = function() {
return this.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__length;
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.bindable__set__length_org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList = function(value) {
this.org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList__length = value;
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__length = function(value) {
var oldValue = this.get__length();
if (oldValue != value) {
this.bindable__set__length_org_apache_royale_jewel_beads_controls_textinput_SearchFilterForList(value);
    this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(
         this, "length", oldValue, value));
}
};


org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__strand = function(value) {
this._strand = value;
org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.KeyboardEvent.KEY_UP, org.apache.royale.utils.Language.closure(this.keyUpHandler, this, 'keyUpHandler'));
org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener('beadsAdded', org.apache.royale.utils.Language.closure(this.onBeadsAdded, this, 'onBeadsAdded'));
};


Object.defineProperties(org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype, /** @lends {org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.jewel.List} */
list: {
get: org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.get__list,
set: org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__list},
/**
  * @export
  * @type {number} */
length: {
get: org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.get__length,
set: org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__length},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SearchFilterForList', qName: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.ROYALE_REFLECTION_INFO = function () {
return {
  accessors: function () {
    return {
      'filterFunction': { type: 'Function', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', metadata: function () { return [ { name: 'Bindable' } ]; }},
      'useDecoration': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', metadata: function () { return [ { name: 'Bindable' } ]; }},
      'list': { type: 'org.apache.royale.jewel.List', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', metadata: function () { return [ { name: 'Bindable' } ]; }},
      'length': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList', metadata: function () { return [ { name: 'Bindable' } ]; }},
      'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList'}
    };
  },
  methods: function () {
    return {
      'SearchFilterForList': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList'}
    };
  }
};
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controls.textinput.SearchFilterForList.prototype.ROYALE_COMPILE_FLAGS = 10;