/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controllers/WizardController.as
 * org.apache.royale.jewel.beads.controllers.WizardController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controllers.WizardController');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.jewel.Wizard');
goog.require('org.apache.royale.jewel.WizardPage');
goog.require('org.apache.royale.jewel.beads.models.WizardModel');
goog.require('org.apache.royale.jewel.beads.models.WizardStep');
goog.require('org.apache.royale.jewel.beads.views.WizardView');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IBeadController');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.core.IBeadController}
 */
org.apache.royale.jewel.beads.controllers.WizardController = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controllers.WizardController', org.apache.royale.jewel.beads.controllers.WizardController);


/**
 * @protected
 * @type {org.apache.royale.jewel.Wizard}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.wizard;


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.handleStepChange = function(event) {
  this.setUpEffects();
  this.wizard.title = this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.stepLabel;
  this.wizard.content.selectedContent = this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.name;
};


/**
 * @private
 * @type {org.apache.royale.jewel.beads.models.WizardModel}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_model;


/**
 * @private
 * @type {org.apache.royale.jewel.beads.views.WizardView}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_view;


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_finishSetUp = function(event) {
  this.org_apache_royale_jewel_beads_controllers_WizardController_view.previousButton.addEventListener(org.apache.royale.events.MouseEvent.CLICK, org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_WizardController_previousButtonClickHandler, this, 'org_apache_royale_jewel_beads_controllers_WizardController_previousButtonClickHandler'));
  this.org_apache_royale_jewel_beads_controllers_WizardController_view.nextButton.addEventListener(org.apache.royale.events.MouseEvent.CLICK, org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_WizardController_nextButtonClickHandler, this, 'org_apache_royale_jewel_beads_controllers_WizardController_nextButtonClickHandler'));
  var /** @type {number} */ n = this.wizard.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.royale.jewel.WizardPage} */ page = org.apache.royale.utils.Language.as(this.wizard.getElementAt(i), org.apache.royale.jewel.WizardPage);
    if (page.step.initialPage) {
      this.wizard.currentStep = page.step;
      page.enterPage();
      break;
    }
  }
};


/**
 * logic to perform when user clicks previous button
 * We assume previous button is visible and enabled so we have a previous step to go
 * We consider going backwards doesn't require validation
 * @private
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_previousButtonClickHandler = function(event) {
  var /** @type {org.apache.royale.jewel.beads.models.WizardStep} */ stepToGo = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep, true);
  this.wizard.dispatchEvent(new org.apache.royale.events.Event("goToPreviousStep"));
  this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep = stepToGo;
};


/**
 * logic to perform when user clicks next button
 * We assume next button is visible and enabled so we have a next step to go
 * - First validate the data in the actual page
 * - if valid findStep to go forward
 * @private
 * @param {org.apache.royale.events.MouseEvent} event
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_nextButtonClickHandler = function(event) {
  if (this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.page.validate()) {
    var /** @type {org.apache.royale.jewel.beads.models.WizardStep} */ stepToGo = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep, false);
    this.wizard.dispatchEvent(new org.apache.royale.events.Event("goToNextStep"));
    this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep = stepToGo;
  }
};


/**
 * Given a step, find a next or previous one taking autoSkip into account
 * autoSkip is only evaluated when going forward.
 * 
 * @asparam step, the step to discover its next
 * @asparam previous, if true find the previous step, if false find the next step. Defaults to find next step
 * @private
 * @param {org.apache.royale.jewel.beads.models.WizardStep} step
 * @param {boolean} previous
 * @return {org.apache.royale.jewel.beads.models.WizardStep}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.org_apache_royale_jewel_beads_controllers_WizardController_findStep = function(step, previous) {
  var /** @type {number} */ n = this.wizard.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.royale.jewel.WizardPage} */ page = org.apache.royale.utils.Language.as(this.wizard.getElementAt(i), org.apache.royale.jewel.WizardPage);
    if (page.step.name == (previous ? step.previousStep : step.nextStep)) {
      return !previous && step.autoSkip ? this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(page.step, previous) : page.step;
    }
  }
  return null;
};


/**
 * @export
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.setUpEffects = function() {
  if (this.org_apache_royale_jewel_beads_controllers_WizardController_model.activateEffect) {
    this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.page.removeClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT);
    this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.page.removeClass(org.apache.royale.jewel.WizardPage.RIGHT_EFFECT);
    var /** @type {org.apache.royale.jewel.beads.models.WizardStep} */ previous = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep, true);
    while (previous != null) {
      if (previous != null && !previous.name)
        break;
      previous.page.removeClass(org.apache.royale.jewel.WizardPage.RIGHT_EFFECT);
      previous.page.addClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT);
      previous = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(previous, true);
    }
    var /** @type {org.apache.royale.jewel.beads.models.WizardStep} */ next = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep, false);
    while (next != null) {
      if (next != null && !next.name)
        break;
      next.page.removeClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT);
      next.page.addClass(org.apache.royale.jewel.WizardPage.RIGHT_EFFECT);
      next = this.org_apache_royale_jewel_beads_controllers_WizardController_findStep(next, false);
    }
    var /** @type {number} */ n = this.wizard.numElements;
    var /** @type {boolean} */ foundSelected;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {org.apache.royale.jewel.WizardPage} */ page = org.apache.royale.utils.Language.as(this.wizard.getElementAt(i), org.apache.royale.jewel.WizardPage);
      if (page == this.org_apache_royale_jewel_beads_controllers_WizardController_model.currentStep.page) {
        foundSelected = true;
        continue;
      }
      if (!page.containsClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT) && !page.containsClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT)) {
        if (foundSelected)
          page.addClass(org.apache.royale.jewel.WizardPage.RIGHT_EFFECT);
        else
          page.addClass(org.apache.royale.jewel.WizardPage.LEFT_EFFECT);
      }
    }
  }
};


org.apache.royale.jewel.beads.controllers.WizardController.prototype.set__strand = function(value) {
  this.wizard = org.apache.royale.utils.Language.as(value, org.apache.royale.jewel.Wizard);
  this.wizard.addEventListener("initComplete", org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_WizardController_finishSetUp, this, 'org_apache_royale_jewel_beads_controllers_WizardController_finishSetUp'));
  this.org_apache_royale_jewel_beads_controllers_WizardController_model = org.apache.royale.utils.Language.as(this.wizard.getBeadByType(org.apache.royale.jewel.beads.models.WizardModel), org.apache.royale.jewel.beads.models.WizardModel);
  this.org_apache_royale_jewel_beads_controllers_WizardController_model.addEventListener("currentStepChange", org.apache.royale.utils.Language.closure(this.handleStepChange, this, 'handleStepChange'));
  this.org_apache_royale_jewel_beads_controllers_WizardController_view = org.apache.royale.utils.Language.as(this.wizard.getBeadByType(org.apache.royale.jewel.beads.views.WizardView), org.apache.royale.jewel.beads.views.WizardView);
};


Object.defineProperties(org.apache.royale.jewel.beads.controllers.WizardController.prototype, /** @lends {org.apache.royale.jewel.beads.controllers.WizardController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controllers.WizardController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'WizardController', qName: 'org.apache.royale.jewel.beads.controllers.WizardController', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.core.IBeadController] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controllers.WizardController'}
      };
    },
    methods: function () {
      return {
        'WizardController': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controllers.WizardController'},
        'setUpEffects': { type: 'void', declaredBy: 'org.apache.royale.jewel.beads.controllers.WizardController'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controllers.WizardController.prototype.ROYALE_COMPILE_FLAGS = 10;