/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/beads/controllers/SnackbarController.as
 * org.apache.royale.jewel.beads.controllers.SnackbarController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.beads.controllers.SnackbarController');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.Snackbar');
goog.require('org.apache.royale.jewel.beads.models.SnackbarModel');
goog.require('org.apache.royale.utils.Timer');
goog.require('org.apache.royale.core.IBeadController');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @implements {org.apache.royale.core.IBeadController}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.beads.controllers.SnackbarController', org.apache.royale.jewel.beads.controllers.SnackbarController);


/**
 * @private
 * @type {org.apache.royale.jewel.Snackbar}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController._singletonInstance;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.org_apache_royale_jewel_beads_controllers_SnackbarController__strand;


/**
 * @private
 * @type {org.apache.royale.utils.Timer}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.org_apache_royale_jewel_beads_controllers_SnackbarController__timer;


/**
 *  Reset the timer for displaying when duration changed
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.org_apache_royale_jewel_beads_controllers_SnackbarController_durationChangeHandler = function(event) {
  if (this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer) {
    this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.reset();
  }
  var /** @type {org.apache.royale.jewel.beads.models.SnackbarModel} */ model = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controllers_SnackbarController__strand.getBeadByType(org.apache.royale.jewel.beads.models.SnackbarModel), org.apache.royale.jewel.beads.models.SnackbarModel);
  if (model.duration < 0) {
    this.org_apache_royale_jewel_beads_controllers_SnackbarController_timerHandler(null);
  } else if (model.duration > 0) {
    if (this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer) {
      this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.delay = model.duration;
    } else {
      this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer = new org.apache.royale.utils.Timer(model.duration);
      this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.addEventListener(org.apache.royale.utils.Timer.TIMER, org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_SnackbarController_timerHandler, this, 'org_apache_royale_jewel_beads_controllers_SnackbarController_timerHandler'));
    }
    this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.start();
  }
};


/**
 *  Dismiss snackbar after duration matching.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.org_apache_royale_jewel_beads_controllers_SnackbarController_timerHandler = function(event) {
  org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controllers_SnackbarController__strand, org.apache.royale.jewel.Snackbar).removeClass("open");
  org.apache.royale.jewel.beads.controllers.SnackbarController._singletonInstance = null;
  if (this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer) {
    this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.stop();
    this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer.removeAllListeners();
    this.org_apache_royale_jewel_beads_controllers_SnackbarController__timer = null;
  }
  setTimeout(org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_SnackbarController_prepareForDismiss, this, 'org_apache_royale_jewel_beads_controllers_SnackbarController_prepareForDismiss'), 400);
};


/**
 * @private
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.org_apache_royale_jewel_beads_controllers_SnackbarController_prepareForDismiss = function() {
  org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controllers_SnackbarController__strand, org.apache.royale.jewel.Snackbar).dismiss();
};


org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.set__strand = function(value) {
  this.org_apache_royale_jewel_beads_controllers_SnackbarController__strand = value;
  if (org.apache.royale.jewel.beads.controllers.SnackbarController._singletonInstance)
    org.apache.royale.jewel.beads.controllers.SnackbarController._singletonInstance.duration = -1;
  org.apache.royale.jewel.beads.controllers.SnackbarController._singletonInstance = org.apache.royale.utils.Language.as(value, org.apache.royale.jewel.Snackbar);
  this.org_apache_royale_jewel_beads_controllers_SnackbarController_durationChangeHandler(null);
  var /** @type {org.apache.royale.jewel.beads.models.SnackbarModel} */ model = org.apache.royale.utils.Language.as(this.org_apache_royale_jewel_beads_controllers_SnackbarController__strand.getBeadByType(org.apache.royale.jewel.beads.models.SnackbarModel), org.apache.royale.jewel.beads.models.SnackbarModel);
  model.addEventListener("durationChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_beads_controllers_SnackbarController_durationChangeHandler, this, 'org_apache_royale_jewel_beads_controllers_SnackbarController_durationChangeHandler'));
};


Object.defineProperties(org.apache.royale.jewel.beads.controllers.SnackbarController.prototype, /** @lends {org.apache.royale.jewel.beads.controllers.SnackbarController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SnackbarController', qName: 'org.apache.royale.jewel.beads.controllers.SnackbarController', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadController] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.jewel.beads.controllers.SnackbarController'}
      };
    },
    methods: function () {
      return {
        'SnackbarController': { type: '', declaredBy: 'org.apache.royale.jewel.beads.controllers.SnackbarController'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.beads.controllers.SnackbarController.prototype.ROYALE_COMPILE_FLAGS = 10;