/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/WizardPage.as
 * org.apache.royale.jewel.WizardPage
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.WizardPage');

goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.SectionContent');
goog.require('org.apache.royale.jewel.Wizard');
goog.require('org.apache.royale.jewel.beads.models.WizardModel');
goog.require('org.apache.royale.jewel.beads.models.WizardStep');
goog.require('org.apache.royale.jewel.beads.views.WizardView');
goog.require('org.apache.royale.jewel.events.WizardEvent');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.SectionContent}
 */
org.apache.royale.jewel.WizardPage = function() {
  org.apache.royale.jewel.WizardPage.base(this, 'constructor');
  this.typeNames = "jewel wizardpage";
};
goog.inherits(org.apache.royale.jewel.WizardPage, org.apache.royale.jewel.SectionContent);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.WizardPage', org.apache.royale.jewel.WizardPage);


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.jewel.WizardPage.LEFT_EFFECT = "slideLeft";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.jewel.WizardPage.RIGHT_EFFECT = "slideRight";


/**
 * @export
 * @type {boolean}
 */
org.apache.royale.jewel.WizardPage.prototype.initialized;


/**
 * @export
 * @type {org.apache.royale.jewel.Wizard}
 */
org.apache.royale.jewel.WizardPage.prototype.wizard;


/**
 * @private
 * @type {org.apache.royale.jewel.beads.models.WizardStep}
 */
org.apache.royale.jewel.WizardPage.prototype.org_apache_royale_jewel_WizardPage__step;


/**
 * Determines whether a view is valid or not
 *
 * defaults true if the form has no validation
 * @export
 * @return {boolean}
 */
org.apache.royale.jewel.WizardPage.prototype.validate = function() {
  return true;
};


/**
 * add listeners to wizard events when add this page to the wizard
 * @export
 * @param {org.apache.royale.jewel.Wizard} wizard
 */
org.apache.royale.jewel.WizardPage.prototype.addWizardListeners = function(wizard) {
  this.wizard = wizard;
  this.model = org.apache.royale.utils.Language.as(wizard.getBeadByType(org.apache.royale.jewel.beads.models.WizardModel), org.apache.royale.jewel.beads.models.WizardModel);
  if (this.model.activateEffect) {
    this.addClass("transitions");
  }
  wizard.addEventListener("goToPreviousStep", org.apache.royale.utils.Language.closure(this.goToPreviousStepHandler, this, 'goToPreviousStepHandler'));
  wizard.addEventListener("goToNextStep", org.apache.royale.utils.Language.closure(this.goToNextStepHandler, this, 'goToNextStepHandler'));
  this.addEventListener("showPreviousButtonChange", org.apache.royale.utils.Language.closure(org.apache.royale.utils.Language.as(wizard.view, org.apache.royale.jewel.beads.views.WizardView, true).showPreviousButtonChangeHandler, org.apache.royale.utils.Language.as(wizard.view, org.apache.royale.jewel.beads.views.WizardView, true), 'showPreviousButtonChangeHandler'));
  this.addEventListener("showNextButtonChange", org.apache.royale.utils.Language.closure(org.apache.royale.utils.Language.as(wizard.view, org.apache.royale.jewel.beads.views.WizardView, true).showNextButtonChangeHandler, org.apache.royale.utils.Language.as(wizard.view, org.apache.royale.jewel.beads.views.WizardView, true), 'showNextButtonChangeHandler'));
  this.addEventListener(org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_NEXT_STEP, org.apache.royale.utils.Language.closure(this.handleNavigationRequest, this, 'handleNavigationRequest'));
  this.addEventListener(org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_PREVIOUS_STEP, org.apache.royale.utils.Language.closure(this.handleNavigationRequest, this, 'handleNavigationRequest'));
  this.addEventListener(org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_TO_STEP, org.apache.royale.utils.Language.closure(this.handleNavigationRequest, this, 'handleNavigationRequest'));
};


/**
 * remove listeners to wizard events when remove this page from the wizard
 * @export
 * @param {org.apache.royale.jewel.Wizard} wizard
 */
org.apache.royale.jewel.WizardPage.prototype.removeWizardListeners = function(wizard) {
  wizard.removeEventListener("goToPreviousStep", org.apache.royale.utils.Language.closure(this.goToPreviousStepHandler, this, 'goToPreviousStepHandler'));
  wizard.removeEventListener("goToNextStep", org.apache.royale.utils.Language.closure(this.goToNextStepHandler, this, 'goToNextStepHandler'));
};


/**
 *
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.WizardPage.prototype.goToPreviousStepHandler = function(event) {
  if (this.model.currentStep.name == this.step.name) {
    this.dispatchEvent(new org.apache.royale.events.Event("exitPage"));
    this.exitPage();
  }
  if (this.model.currentStep.previousStep == this.step.name) {
    this.model.showPreviousButton = this.showPreviousButton;
    this.model.showNextButton = this.showNextButton;
    this.dispatchEvent(new org.apache.royale.events.Event("enterPage"));
    this.enterPage();
  }
};


/**
 * exit page
 * @export
 */
org.apache.royale.jewel.WizardPage.prototype.exitPage = function() {
};


/**
 *
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.jewel.WizardPage.prototype.goToNextStepHandler = function(event) {
  if (this.model.currentStep.name == this.step.name) {
    this.dispatchEvent(new org.apache.royale.events.Event("exitPage"));
    this.exitPage();
  }
  if (this.model.currentStep.nextStep == this.step.name) {
    this.model.showPreviousButton = this.showPreviousButton;
    this.model.showNextButton = this.showNextButton;
    this.dispatchEvent(new org.apache.royale.events.Event("enterPage"));
    this.enterPage();
  }
};


/**
 * enter page
 * @export
 */
org.apache.royale.jewel.WizardPage.prototype.enterPage = function() {
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.WizardPage.prototype.org_apache_royale_jewel_WizardPage__showPreviousButton = true;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.WizardPage.prototype.org_apache_royale_jewel_WizardPage__showNextButton = true;


/**
 * 
 * 
 * @asparam event 
 * @protected
 * @param {org.apache.royale.jewel.events.WizardEvent} event
 */
org.apache.royale.jewel.WizardPage.prototype.handleNavigationRequest = function(event) {
  switch (event.type) {
    case org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_TO_STEP:
      this.wizard.showPage(event.stepName);
      break;
    case org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_PREVIOUS_STEP:
      this.wizard.dispatchEvent(new org.apache.royale.events.Event("goToPreviousStep"));
      this.model.currentStep = this.wizard.findStepByName(this.wizard.currentStep.previousStep);
      break;
    case org.apache.royale.jewel.events.WizardEvent.REQUEST_NAVIGATE_NEXT_STEP:
      this.wizard.dispatchEvent(new org.apache.royale.events.Event("goToNextStep"));
      this.model.currentStep = this.wizard.findStepByName(this.wizard.currentStep.nextStep);
      break;
  }
};


org.apache.royale.jewel.WizardPage.prototype.get__step = function() {
  return this.org_apache_royale_jewel_WizardPage__step;
};


org.apache.royale.jewel.WizardPage.prototype.set__step = function(value) {
  this.org_apache_royale_jewel_WizardPage__step = value;
};


org.apache.royale.jewel.WizardPage.prototype.get__showPreviousButton = function() {
  return this.org_apache_royale_jewel_WizardPage__showPreviousButton;
};


org.apache.royale.jewel.WizardPage.prototype.set__showPreviousButton = function(value) {
  this.org_apache_royale_jewel_WizardPage__showPreviousButton = value;
  this.dispatchEvent(new org.apache.royale.events.Event("showPreviousButtonChange"));
};


org.apache.royale.jewel.WizardPage.prototype.get__showNextButton = function() {
  return this.org_apache_royale_jewel_WizardPage__showNextButton;
};


org.apache.royale.jewel.WizardPage.prototype.set__showNextButton = function(value) {
  this.org_apache_royale_jewel_WizardPage__showNextButton = value;
  this.dispatchEvent(new org.apache.royale.events.Event("showNextButtonChange"));
};


Object.defineProperties(org.apache.royale.jewel.WizardPage.prototype, /** @lends {org.apache.royale.jewel.WizardPage.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.jewel.beads.models.WizardStep} */
step: {
get: org.apache.royale.jewel.WizardPage.prototype.get__step,
set: org.apache.royale.jewel.WizardPage.prototype.set__step},
/**
  * @export
  * @type {boolean} */
showPreviousButton: {
get: org.apache.royale.jewel.WizardPage.prototype.get__showPreviousButton,
set: org.apache.royale.jewel.WizardPage.prototype.set__showPreviousButton},
/**
  * @export
  * @type {boolean} */
showNextButton: {
get: org.apache.royale.jewel.WizardPage.prototype.get__showNextButton,
set: org.apache.royale.jewel.WizardPage.prototype.set__showNextButton}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.WizardPage.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'WizardPage', qName: 'org.apache.royale.jewel.WizardPage', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.WizardPage.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'initialized': { type: 'Boolean', get_set: function (/** org.apache.royale.jewel.WizardPage */ inst, /** * */ v) {return v !== undefined ? inst.initialized = v : inst.initialized;}},
        'wizard': { type: 'org.apache.royale.jewel.Wizard', get_set: function (/** org.apache.royale.jewel.WizardPage */ inst, /** * */ v) {return v !== undefined ? inst.wizard = v : inst.wizard;}}
      };
    },
    accessors: function () {
      return {
        'step': { type: 'org.apache.royale.jewel.beads.models.WizardStep', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.WizardPage', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'showPreviousButton': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.WizardPage'},
        'showNextButton': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.WizardPage'}
      };
    },
    methods: function () {
      return {
        'WizardPage': { type: '', declaredBy: 'org.apache.royale.jewel.WizardPage'},
        'validate': { type: 'Boolean', declaredBy: 'org.apache.royale.jewel.WizardPage'},
        'addWizardListeners': { type: 'void', declaredBy: 'org.apache.royale.jewel.WizardPage', parameters: function () { return [ 'org.apache.royale.jewel.Wizard', false ]; }},
        'removeWizardListeners': { type: 'void', declaredBy: 'org.apache.royale.jewel.WizardPage', parameters: function () { return [ 'org.apache.royale.jewel.Wizard', false ]; }},
        'exitPage': { type: 'void', declaredBy: 'org.apache.royale.jewel.WizardPage'},
        'enterPage': { type: 'void', declaredBy: 'org.apache.royale.jewel.WizardPage'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.WizardPage.prototype.ROYALE_COMPILE_FLAGS = 10;