/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/TopAppBar.as
 * org.apache.royale.jewel.TopAppBar
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.TopAppBar');

goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.Bar');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.Bar}
 */
org.apache.royale.jewel.TopAppBar = function() {
  org.apache.royale.jewel.TopAppBar.base(this, 'constructor');
  this.typeNames = "jewel topappbar";
  this.org_apache_royale_jewel_TopAppBar_setListenersForFixed();
};
goog.inherits(org.apache.royale.jewel.TopAppBar, org.apache.royale.jewel.Bar);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.TopAppBar', org.apache.royale.jewel.TopAppBar);


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.TopAppBar.prototype.org_apache_royale_jewel_TopAppBar_currentOffset = 0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.jewel.TopAppBar.prototype.org_apache_royale_jewel_TopAppBar_lastPosition = 0;


/**
 * @private
 */
org.apache.royale.jewel.TopAppBar.prototype.org_apache_royale_jewel_TopAppBar_setListenersForFixed = function() {
  if (this._fixed) {
    this.element.classList.add("fixed");
    window.removeEventListener('scroll', org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_TopAppBar_scrollHandler, this, 'org_apache_royale_jewel_TopAppBar_scrollHandler'), false);
  } else {
    this.element.classList.remove("fixed");
    window.addEventListener('scroll', org.apache.royale.utils.Language.closure(this.org_apache_royale_jewel_TopAppBar_scrollHandler, this, 'org_apache_royale_jewel_TopAppBar_scrollHandler'), false);
  }
};


/**
 *  If not fixed this scroll handler manages that the top bar doesn't get lost above
 *  and will get back to screen sooner since only get scroll up by its size
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @private
 * @param {org.apache.royale.events.Event=} event
 */
org.apache.royale.jewel.TopAppBar.prototype.org_apache_royale_jewel_TopAppBar_scrollHandler = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  var /** @type {number} */ offset;
  var /** @type {number} */ currentPosition = Math.max(window.pageYOffset, 0);
  var /** @type {number} */ diff = currentPosition - this.org_apache_royale_jewel_TopAppBar_lastPosition;
  this.org_apache_royale_jewel_TopAppBar_lastPosition = currentPosition;
  this.org_apache_royale_jewel_TopAppBar_currentOffset -= diff;
  if (this.org_apache_royale_jewel_TopAppBar_currentOffset > 0) {
    this.org_apache_royale_jewel_TopAppBar_currentOffset = 0;
  } else if (Math.abs(this.org_apache_royale_jewel_TopAppBar_currentOffset) > this.element.clientHeight) {
    this.org_apache_royale_jewel_TopAppBar_currentOffset = -this.element.clientHeight;
  }
  offset = this.org_apache_royale_jewel_TopAppBar_currentOffset;
  if (Math.abs(offset) >= this.element.clientHeight) {
    offset = -128;
  }
  this.element.style.top = offset + "px";
};


/**
 * @protected
 * @type {boolean}
 */
org.apache.royale.jewel.TopAppBar.prototype._fixed = false;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.TopAppBar.prototype.org_apache_royale_jewel_TopAppBar__hasDrawer;


org.apache.royale.jewel.TopAppBar.prototype.get__headerClassName = function() {
  return "topBarAppHeader";
};


org.apache.royale.jewel.TopAppBar.prototype.get__fixed = function() {
  return this._fixed;
};


org.apache.royale.jewel.TopAppBar.prototype.set__fixed = function(value) {
  if (this._fixed != value) {
    this._fixed = value;
    this.org_apache_royale_jewel_TopAppBar_setListenersForFixed();
  }
};


org.apache.royale.jewel.TopAppBar.prototype.get__hasDrawer = function() {
  return this.org_apache_royale_jewel_TopAppBar__hasDrawer;
};


org.apache.royale.jewel.TopAppBar.prototype.set__hasDrawer = function(value) {
  if (this.org_apache_royale_jewel_TopAppBar__hasDrawer != value) {
    this.org_apache_royale_jewel_TopAppBar__hasDrawer = value;
    if (this.org_apache_royale_jewel_TopAppBar__hasDrawer) {
      this.element.classList.add("has-drawer");
    } else {
      this.element.classList.remove("has-drawer");
    }
  }
};


Object.defineProperties(org.apache.royale.jewel.TopAppBar.prototype, /** @lends {org.apache.royale.jewel.TopAppBar.prototype} */ {
/**
  * @type {string} */
headerClassName: {
get: org.apache.royale.jewel.TopAppBar.prototype.get__headerClassName},
/**
  * @export
  * @type {boolean} */
fixed: {
get: org.apache.royale.jewel.TopAppBar.prototype.get__fixed,
set: org.apache.royale.jewel.TopAppBar.prototype.set__fixed},
/**
  * @export
  * @type {boolean} */
hasDrawer: {
get: org.apache.royale.jewel.TopAppBar.prototype.get__hasDrawer,
set: org.apache.royale.jewel.TopAppBar.prototype.set__hasDrawer}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.TopAppBar.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'TopAppBar', qName: 'org.apache.royale.jewel.TopAppBar', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.TopAppBar.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'fixed': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.TopAppBar'},
        'hasDrawer': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.TopAppBar'}
      };
    },
    methods: function () {
      return {
        'TopAppBar': { type: '', declaredBy: 'org.apache.royale.jewel.TopAppBar'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.TopAppBar.prototype.ROYALE_COMPILE_FLAGS = 10;