/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/Snackbar.as
 * org.apache.royale.jewel.Snackbar
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.Snackbar');

goog.require('org.apache.royale.core.StyledUIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.jewel.beads.models.SnackbarModel');
goog.require('org.apache.royale.core.IPopUp');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.core.StyledUIBase}
 * @implements {org.apache.royale.core.IPopUp}
 */
org.apache.royale.jewel.Snackbar = function() {
  org.apache.royale.jewel.Snackbar.base(this, 'constructor');
  this.typeNames = "jewel snackbar layout";
};
goog.inherits(org.apache.royale.jewel.Snackbar, org.apache.royale.core.StyledUIBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.Snackbar', org.apache.royale.jewel.Snackbar);


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.Snackbar.prototype.org_apache_royale_jewel_Snackbar__isAddedToParent;


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.jewel.Snackbar.ACTION = "action";


/**
 *  This static method is a convenience function to quickly create and display an Snackbar. The
 *  message paramters are required, the others will default.
 *
 *  @asparam String message The message content of the Snackbar.
 *  @asparam int duration How long to show the Snackbar for.
 *  @asparam String actionText The action text of the Snackbar.
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {string} message
 * @param {number=} duration
 * @param {string=} actionText
 * @param {Object=} parent
 * @return {org.apache.royale.jewel.Snackbar}
 */
org.apache.royale.jewel.Snackbar.show = function(message, duration, actionText, parent) {
  duration = typeof duration !== 'undefined' ? duration : 4000;
  actionText = typeof actionText !== 'undefined' ? actionText : null;
  parent = typeof parent !== 'undefined' ? parent : null;
  var /** @type {org.apache.royale.jewel.Snackbar} */ snackbar = new org.apache.royale.jewel.Snackbar();
  snackbar.message = message;
  snackbar.duration = duration;
  snackbar.action = actionText;
  snackbar.show(parent);
  return snackbar;
};


/**
 *  Shows the Snackbar anchored to a root component such
 *  as body
 * 
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {Object=} parentContainer
 */
org.apache.royale.jewel.Snackbar.prototype.show = function(parentContainer) {
  parentContainer = typeof parentContainer !== 'undefined' ? parentContainer : null;
  if (parentContainer) {
    this.org_apache_royale_jewel_Snackbar__isAddedToParent = true;
    parentContainer.element.appendChild(this.element);
  } else {
    this.org_apache_royale_jewel_Snackbar__isAddedToParent = false;
    var /** @type {HTMLElement} */ body = document.getElementsByTagName('body')[0];
    body.appendChild(this.element);
  }
  this.addedToParent();
  
};


/**
 *  Dismiss the snackbar.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.events.Event=} event
 */
org.apache.royale.jewel.Snackbar.prototype.dismiss = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  this.removeAllListeners();
  if (this.org_apache_royale_jewel_Snackbar__isAddedToParent) {
    this.parent["element"].removeChild(this.element);
  } else {
    var /** @type {HTMLElement} */ body = document.getElementsByTagName('body')[0];
    body.removeChild(this.element);
  }
  this.org_apache_royale_jewel_Snackbar__isAddedToParent = false;
};


org.apache.royale.jewel.Snackbar.prototype.get__duration = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).duration;
};


org.apache.royale.jewel.Snackbar.prototype.set__duration = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).duration = value;
};


org.apache.royale.jewel.Snackbar.prototype.get__message = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).message;
};


org.apache.royale.jewel.Snackbar.prototype.set__message = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).message = value;
};


org.apache.royale.jewel.Snackbar.prototype.get__action = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).action;
};


org.apache.royale.jewel.Snackbar.prototype.set__action = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.SnackbarModel, true).action = value;
};


Object.defineProperties(org.apache.royale.jewel.Snackbar.prototype, /** @lends {org.apache.royale.jewel.Snackbar.prototype} */ {
/**
  * @export
  * @type {number} */
duration: {
get: org.apache.royale.jewel.Snackbar.prototype.get__duration,
set: org.apache.royale.jewel.Snackbar.prototype.set__duration},
/**
  * @export
  * @type {string} */
message: {
get: org.apache.royale.jewel.Snackbar.prototype.get__message,
set: org.apache.royale.jewel.Snackbar.prototype.set__message},
/**
  * @export
  * @type {string} */
action: {
get: org.apache.royale.jewel.Snackbar.prototype.get__action,
set: org.apache.royale.jewel.Snackbar.prototype.set__action}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.Snackbar.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Snackbar', qName: 'org.apache.royale.jewel.Snackbar', kind: 'class' }], interfaces: [org.apache.royale.core.IPopUp] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.Snackbar.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'duration': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Snackbar'},
        'message': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Snackbar'},
        'action': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Snackbar'}
      };
    },
    methods: function () {
      return {
        'Snackbar': { type: '', declaredBy: 'org.apache.royale.jewel.Snackbar'},
        '|show': { type: 'org.apache.royale.jewel.Snackbar', declaredBy: 'org.apache.royale.jewel.Snackbar', parameters: function () { return [ 'String', false ,'int', true ,'String', true ,'Object', true ]; }},
        'show': { type: 'void', declaredBy: 'org.apache.royale.jewel.Snackbar', parameters: function () { return [ 'Object', true ]; }},
        'dismiss': { type: 'void', declaredBy: 'org.apache.royale.jewel.Snackbar', parameters: function () { return [ 'org.apache.royale.events.Event', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Snackbar.prototype.ROYALE_COMPILE_FLAGS = 10;