/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/RadioButton.as
 * org.apache.royale.jewel.RadioButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.RadioButton');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.MouseEvent');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.jewel.supportClasses.button.SelectableButtonBase');
goog.require('org.apache.royale.jewel.supportClasses.IInputButton');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.supportClasses.button.SelectableButtonBase}
 * @implements {org.apache.royale.jewel.supportClasses.IInputButton}
 */
org.apache.royale.jewel.RadioButton = function() {
  org.apache.royale.jewel.RadioButton.base(this, 'constructor');
  this.typeNames = "jewel radiobutton";
};
goog.inherits(org.apache.royale.jewel.RadioButton, org.apache.royale.jewel.supportClasses.button.SelectableButtonBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.RadioButton', org.apache.royale.jewel.RadioButton);


/**
 * @protected
 * @type {HTMLInputElement}
 */
org.apache.royale.jewel.RadioButton.prototype.icon;


/**
 * @protected
 * @type {HTMLSpanElement}
 */
org.apache.royale.jewel.RadioButton.prototype.radio;


/**
 * @protected
 * @type {Text}
 */
org.apache.royale.jewel.RadioButton.prototype.textNode;


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @royaleignorecoercion HTMLInputElement
 * @royaleignorecoercion HTMLSpanElement
 * @royaleignorecoercion Text
 * @protected
 * @override
 */
org.apache.royale.jewel.RadioButton.prototype.createElement = function() {
  this.icon = org.apache.royale.html.util.addElementToWrapper(this, 'input');
  this.icon.type = 'radio';
  this.icon.id = '_radio_' + Math.random();
  this.icon.value = String(this.value);
  this.textNode = document.createTextNode('');
  this.radio = document.createElement('span');
  this.radio.appendChild(this.textNode);
  this.positioner = document.createElement('label');
  return this.element;
};


/**
 * @private
 * @type {Object}
 */
org.apache.royale.jewel.RadioButton.prototype.org_apache_royale_jewel_RadioButton__positioner;


/**
 * @copy org.apache.royale.events.EventDispatcher#addEventListener
 * @export
 * @override
 */
org.apache.royale.jewel.RadioButton.prototype.addEventListener = function(type, handler, opt_capture, opt_handlerScope) {
  opt_capture = typeof opt_capture !== 'undefined' ? opt_capture : false;
  opt_handlerScope = typeof opt_handlerScope !== 'undefined' ? opt_handlerScope : null;
  if (type == org.apache.royale.events.MouseEvent.CLICK) {
    this.icon.addEventListener(type, handler, opt_capture);
  } else {
    org.apache.royale.jewel.RadioButton.superClass_.addEventListener.apply(this, [ type, handler, opt_capture, opt_handlerScope] );
  }
};


org.apache.royale.jewel.RadioButton.prototype.get__selected = function() {
  
  return this.icon.checked;
};


org.apache.royale.jewel.RadioButton.prototype.set__selected = function(selValue) {
  
  if (this.icon.checked == selValue) {
    return;
  }
  this.icon.checked = selValue;
  this.dispatchEvent(new org.apache.royale.events.Event(org.apache.royale.events.Event.CHANGE));
};


org.apache.royale.jewel.RadioButton.prototype.get__selectedValue = function() {
  
  var /** @type {string} */ groupName = org.apache.royale.utils.Language.as(this.icon.name, String);
  var /** @type {NodeList} */ buttons = document.getElementsByName(groupName);
  var /** @type {number} */ n = (buttons.length) >> 0;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (buttons[i].checked) {
      return buttons[i].value;
    }
  }
  return null;
};


org.apache.royale.jewel.RadioButton.prototype.set__selectedValue = function(newValue) {
  
  var /** @type {string} */ groupName = org.apache.royale.utils.Language.as(this.icon.name, String);
  var /** @type {NodeList} */ buttons = document.getElementsByName(groupName);
  var /** @type {number} */ n = (buttons.length) >> 0;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (buttons[i].value === this.value) {
      buttons[i].checked = true;
      break;
    }
  }
};


org.apache.royale.jewel.RadioButton.prototype.get__text = function() {
  
  return this.textNode.nodeValue;
};


org.apache.royale.jewel.RadioButton.prototype.set__text = function(value) {
  
  this.textNode.nodeValue = value;
};


org.apache.royale.jewel.RadioButton.prototype.get__value = function() {
  
  return this.icon.value;
};


org.apache.royale.jewel.RadioButton.prototype.set__value = function(value) {
  
  this.icon.value = String(value);
};


org.apache.royale.jewel.RadioButton.prototype.get__groupName = function() {
  
  return org.apache.royale.utils.Language.as(this.icon.name, String);
};


org.apache.royale.jewel.RadioButton.prototype.set__groupName = function(value) {
  
  this.icon.name = value;
};


org.apache.royale.jewel.RadioButton.prototype.get__inputButton = function() {
  return this.icon;
};


org.apache.royale.jewel.RadioButton.prototype.get__positioner = function() {
  return this.org_apache_royale_jewel_RadioButton__positioner;
};


org.apache.royale.jewel.RadioButton.prototype.set__positioner = function(value) {
  this.org_apache_royale_jewel_RadioButton__positioner = value;
  this.org_apache_royale_jewel_RadioButton__positioner.royale_wrapper = this;
  this.org_apache_royale_jewel_RadioButton__positioner.appendChild(this.element);
  this.org_apache_royale_jewel_RadioButton__positioner.appendChild(this.radio);
};


Object.defineProperties(org.apache.royale.jewel.RadioButton.prototype, /** @lends {org.apache.royale.jewel.RadioButton.prototype} */ {
/**
  * @export
  * @type {boolean} */
selected: {
get: org.apache.royale.jewel.RadioButton.prototype.get__selected,
set: org.apache.royale.jewel.RadioButton.prototype.set__selected},
/**
  * @export
  * @type {Object} */
selectedValue: {
get: org.apache.royale.jewel.RadioButton.prototype.get__selectedValue,
set: org.apache.royale.jewel.RadioButton.prototype.set__selectedValue},
/**
  * @export
  * @type {string} */
text: {
get: org.apache.royale.jewel.RadioButton.prototype.get__text,
set: org.apache.royale.jewel.RadioButton.prototype.set__text},
/**
  * @export
  * @type {Object} */
value: {
get: org.apache.royale.jewel.RadioButton.prototype.get__value,
set: org.apache.royale.jewel.RadioButton.prototype.set__value},
/**
  * @export
  * @type {string} */
groupName: {
get: org.apache.royale.jewel.RadioButton.prototype.get__groupName,
set: org.apache.royale.jewel.RadioButton.prototype.set__groupName},
/**
  * @export
  * @type {HTMLInputElement} */
inputButton: {
get: org.apache.royale.jewel.RadioButton.prototype.get__inputButton},
/**
  * @export
  * @type {org.apache.royale.core.WrappedHTMLElement} */
positioner: {
get: org.apache.royale.jewel.RadioButton.prototype.get__positioner,
set: org.apache.royale.jewel.RadioButton.prototype.set__positioner}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.RadioButton.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'RadioButton', qName: 'org.apache.royale.jewel.RadioButton', kind: 'class' }], interfaces: [org.apache.royale.jewel.supportClasses.IInputButton] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.RadioButton.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'selected': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'selectedValue': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'text': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'value': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'groupName': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'inputButton': { type: 'HTMLInputElement', access: 'readonly', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'positioner': { type: 'org.apache.royale.core.WrappedHTMLElement', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.RadioButton'}
      };
    },
    methods: function () {
      return {
        'RadioButton': { type: '', declaredBy: 'org.apache.royale.jewel.RadioButton'},
        'addEventListener': { type: 'void', declaredBy: 'org.apache.royale.jewel.RadioButton', parameters: function () { return [ 'String', false ,'Function', false ,'Boolean', true ,'Object', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.RadioButton.prototype.ROYALE_COMPILE_FLAGS = 10;