/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/DropDownList.as
 * org.apache.royale.jewel.DropDownList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.DropDownList');

goog.require('org.apache.royale.core.IDataProviderModel');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.elements.Select');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.jewel.beads.models.IDropDownListModel');
goog.require('org.apache.royale.jewel.beads.models.ListPresentationModel');
goog.require('org.apache.royale.jewel.supportClasses.container.DataContainerBase');
goog.require('org.apache.royale.jewel.supportClasses.list.IListPresentationModel');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.supportClasses.container.DataContainerBase}
 */
org.apache.royale.jewel.DropDownList = function() {
  org.apache.royale.jewel.DropDownList.base(this, 'constructor');
  this.typeNames = "jewel dropdownlist";
};
goog.inherits(org.apache.royale.jewel.DropDownList, org.apache.royale.jewel.supportClasses.container.DataContainerBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.DropDownList', org.apache.royale.jewel.DropDownList);


/**
 * @protected
 * @type {org.apache.royale.html.elements.Select}
 */
org.apache.royale.jewel.DropDownList.prototype._dropDown;


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @royaleignorecoercion HTMLSelectElement
 * @protected
 * @override
 */
org.apache.royale.jewel.DropDownList.prototype.createElement = function() {
  org.apache.royale.html.util.addElementToWrapper(this, 'select');
  this.element.size = 1;
  goog.events.listen(this.element, 'change', org.apache.royale.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  return this.element;
};


/**
 * @royaleignorecoercion HTMLSelectElement
 * @protected
 * @param {Event} event
 */
org.apache.royale.jewel.DropDownList.prototype.changeHandler = function(event) {
  var /** @type {number} */ index = (this.element.selectedIndex) >> 0;
  var /** @type {org.apache.royale.jewel.beads.models.IDropDownListModel} */ ddModel = org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.IDropDownListModel);
  if (ddModel) {
    index -= ddModel.offset;
  }
  this.model.selectedIndex = index;
};


org.apache.royale.jewel.DropDownList.prototype.get__dropDown = function() {
  return this._dropDown;
};


org.apache.royale.jewel.DropDownList.prototype.set__dropDown = function(value) {
  this._dropDown = value;
};


org.apache.royale.jewel.DropDownList.prototype.get__labelField = function() {
  return this.model.labelField;
};


org.apache.royale.jewel.DropDownList.prototype.set__labelField = function(value) {
  this.model.labelField = value;
};


org.apache.royale.jewel.DropDownList.prototype.get__dataProvider = function() {
  return this.model.dataProvider;
};


org.apache.royale.jewel.DropDownList.prototype.set__dataProvider = function(value) {
  this.model.dataProvider = value;
};


org.apache.royale.jewel.DropDownList.prototype.get__selectedIndex = function() {
  return this.model.selectedIndex;
};


org.apache.royale.jewel.DropDownList.prototype.set__selectedIndex = function(value) {
  this.model.selectedIndex = value;
  value = this.model.selectedIndex;
  if (org.apache.royale.utils.Language.is(this.model, org.apache.royale.jewel.beads.models.IDropDownListModel)) {
    value += this.model.offset;
  }
  this.element.selectedIndex = value;
};


org.apache.royale.jewel.DropDownList.prototype.get__selectedItem = function() {
  return this.model.selectedItem;
};


org.apache.royale.jewel.DropDownList.prototype.set__selectedItem = function(value) {
  this.model.selectedItem = value;
  
/**
 * @const
 * @type {number}
 */
var offset = (org.apache.royale.utils.Language.is(this.model, org.apache.royale.jewel.beads.models.IDropDownListModel) ? org.apache.royale.utils.Language.as(this.model, org.apache.royale.jewel.beads.models.IDropDownListModel, true).offset : 0) >> 0;
  this.element.selectedIndex = this.model.selectedIndex + offset;
};


org.apache.royale.jewel.DropDownList.prototype.get__presentationModel = function() {
  var /** @type {org.apache.royale.jewel.supportClasses.list.IListPresentationModel} */ presModel = this.getBeadByType(org.apache.royale.jewel.supportClasses.list.IListPresentationModel);
  if (presModel == null) {
    presModel = new org.apache.royale.jewel.beads.models.ListPresentationModel();
    this.addBead(presModel);
  }
  return presModel;
};


Object.defineProperties(org.apache.royale.jewel.DropDownList.prototype, /** @lends {org.apache.royale.jewel.DropDownList.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.html.elements.Select} */
dropDown: {
get: org.apache.royale.jewel.DropDownList.prototype.get__dropDown,
set: org.apache.royale.jewel.DropDownList.prototype.set__dropDown},
/**
  * @export
  * @type {string} */
labelField: {
get: org.apache.royale.jewel.DropDownList.prototype.get__labelField,
set: org.apache.royale.jewel.DropDownList.prototype.set__labelField},
/**
  * @export
  * @type {Object} */
dataProvider: {
get: org.apache.royale.jewel.DropDownList.prototype.get__dataProvider,
set: org.apache.royale.jewel.DropDownList.prototype.set__dataProvider},
/**
  * @export
  * @type {number} */
selectedIndex: {
get: org.apache.royale.jewel.DropDownList.prototype.get__selectedIndex,
set: org.apache.royale.jewel.DropDownList.prototype.set__selectedIndex},
/**
  * @export
  * @type {Object} */
selectedItem: {
get: org.apache.royale.jewel.DropDownList.prototype.get__selectedItem,
set: org.apache.royale.jewel.DropDownList.prototype.set__selectedItem},
/**
  * @export
  * @type {org.apache.royale.jewel.supportClasses.list.IListPresentationModel} */
presentationModel: {
get: org.apache.royale.jewel.DropDownList.prototype.get__presentationModel}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.DropDownList.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DropDownList', qName: 'org.apache.royale.jewel.DropDownList', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.DropDownList.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'dropDown': { type: 'org.apache.royale.html.elements.Select', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.DropDownList'},
        'labelField': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'labelFieldChanged' } ] } ]; }},
        'dataProvider': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'dataProviderChanged' } ] } ]; }},
        'selectedIndex': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'selectionChanged' } ] } ]; }},
        'selectedItem': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'selectionChanged' } ] } ]; }},
        'presentationModel': { type: 'org.apache.royale.jewel.supportClasses.list.IListPresentationModel', access: 'readonly', declaredBy: 'org.apache.royale.jewel.DropDownList'}
      };
    },
    methods: function () {
      return {
        'DropDownList': { type: '', declaredBy: 'org.apache.royale.jewel.DropDownList'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.DropDownList.prototype.ROYALE_COMPILE_FLAGS = 10;