/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/CheckBox.as
 * org.apache.royale.jewel.CheckBox
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.CheckBox');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.jewel.supportClasses.button.SelectableButtonBase');
goog.require('org.apache.royale.jewel.supportClasses.IInputButton');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.supportClasses.button.SelectableButtonBase}
 * @implements {org.apache.royale.jewel.supportClasses.IInputButton}
 */
org.apache.royale.jewel.CheckBox = function() {
  org.apache.royale.jewel.CheckBox.base(this, 'constructor');
  this.typeNames = "jewel checkbox";
};
goog.inherits(org.apache.royale.jewel.CheckBox, org.apache.royale.jewel.supportClasses.button.SelectableButtonBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.CheckBox', org.apache.royale.jewel.CheckBox);


/**
 * @export
 * @type {HTMLInputElement}
 */
org.apache.royale.jewel.CheckBox.prototype.input;


/**
 * @protected
 * @type {HTMLSpanElement}
 */
org.apache.royale.jewel.CheckBox.prototype.checkbox;


/**
 * @protected
 * @type {Text}
 */
org.apache.royale.jewel.CheckBox.prototype.textNode;


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @royaleignorecoercion HTMLInputElement
 * @royaleignorecoercion HTMLSpanElement
 * @protected
 * @override
 */
org.apache.royale.jewel.CheckBox.prototype.createElement = function() {
  this.input = org.apache.royale.html.util.addElementToWrapper(this, 'input');
  this.input.type = 'checkbox';
  this.checkbox = document.createElement('span');
  this.positioner = document.createElement('label');
  return this.element;
};


/**
 * @private
 * @type {Object}
 */
org.apache.royale.jewel.CheckBox.prototype.org_apache_royale_jewel_CheckBox__positioner;


org.apache.royale.jewel.CheckBox.prototype.get__selected = function() {
  
  return this.input.checked;
};


org.apache.royale.jewel.CheckBox.prototype.set__selected = function(value) {
  
  if (this.input.checked == value)
    return;
  this.input.checked = value;
  this.dispatchEvent(new org.apache.royale.events.Event(org.apache.royale.events.Event.CHANGE));
};


org.apache.royale.jewel.CheckBox.prototype.get__text = function() {
  
  return this.textNode ? this.textNode.nodeValue : "";
};


org.apache.royale.jewel.CheckBox.prototype.set__text = function(value) {
  
  if (!this.textNode) {
    this.textNode = org.apache.royale.utils.Language.as(document.createTextNode(''), Text);
    this.checkbox.appendChild(this.textNode);
  }
  this.textNode.nodeValue = value;
};


org.apache.royale.jewel.CheckBox.prototype.get__value = function() {
  
  return this.input.value;
};


org.apache.royale.jewel.CheckBox.prototype.set__value = function(newValue) {
  
  this.input.value = newValue;
};


org.apache.royale.jewel.CheckBox.prototype.get__inputButton = function() {
  return this.input;
};


org.apache.royale.jewel.CheckBox.prototype.get__positioner = function() {
  return this.org_apache_royale_jewel_CheckBox__positioner;
};


org.apache.royale.jewel.CheckBox.prototype.set__positioner = function(value) {
  this.org_apache_royale_jewel_CheckBox__positioner = value;
  this.org_apache_royale_jewel_CheckBox__positioner.royale_wrapper = this;
  this.org_apache_royale_jewel_CheckBox__positioner.appendChild(this.element);
  this.org_apache_royale_jewel_CheckBox__positioner.appendChild(this.checkbox);
};


Object.defineProperties(org.apache.royale.jewel.CheckBox.prototype, /** @lends {org.apache.royale.jewel.CheckBox.prototype} */ {
/**
  * @export
  * @type {boolean} */
selected: {
get: org.apache.royale.jewel.CheckBox.prototype.get__selected,
set: org.apache.royale.jewel.CheckBox.prototype.set__selected},
/**
  * @export
  * @type {string} */
text: {
get: org.apache.royale.jewel.CheckBox.prototype.get__text,
set: org.apache.royale.jewel.CheckBox.prototype.set__text},
/**
  * @export
  * @type {string} */
value: {
get: org.apache.royale.jewel.CheckBox.prototype.get__value,
set: org.apache.royale.jewel.CheckBox.prototype.set__value},
/**
  * @export
  * @type {HTMLInputElement} */
inputButton: {
get: org.apache.royale.jewel.CheckBox.prototype.get__inputButton},
/**
  * @export
  * @type {org.apache.royale.core.WrappedHTMLElement} */
positioner: {
get: org.apache.royale.jewel.CheckBox.prototype.get__positioner,
set: org.apache.royale.jewel.CheckBox.prototype.set__positioner}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.CheckBox.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CheckBox', qName: 'org.apache.royale.jewel.CheckBox', kind: 'class' }], interfaces: [org.apache.royale.jewel.supportClasses.IInputButton] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.CheckBox.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'input': { type: 'HTMLInputElement', get_set: function (/** org.apache.royale.jewel.CheckBox */ inst, /** * */ v) {return v !== undefined ? inst.input = v : inst.input;}}
      };
    },
    accessors: function () {
      return {
        'selected': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.CheckBox', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'text': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.CheckBox'},
        'value': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.CheckBox'},
        'inputButton': { type: 'HTMLInputElement', access: 'readonly', declaredBy: 'org.apache.royale.jewel.CheckBox'},
        'positioner': { type: 'org.apache.royale.core.WrappedHTMLElement', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.CheckBox'}
      };
    },
    methods: function () {
      return {
        'CheckBox': { type: '', declaredBy: 'org.apache.royale.jewel.CheckBox'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.CheckBox.prototype.ROYALE_COMPILE_FLAGS = 10;