/**
 * Generated by Apache Royale Compiler from org/apache/royale/jewel/Alert.as
 * org.apache.royale.jewel.Alert
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.jewel.Alert');

goog.require('org.apache.royale.core.IAlertModel');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.events.CloseEvent');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.jewel.Group');
goog.require('org.apache.royale.core.IPopUp');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 * @extends {org.apache.royale.jewel.Group}
 * @implements {org.apache.royale.core.IPopUp}
 */
org.apache.royale.jewel.Alert = function() {
  org.apache.royale.jewel.Alert.base(this, 'constructor');
  this.typeNames = "jewel alert";
};
goog.inherits(org.apache.royale.jewel.Alert, org.apache.royale.jewel.Group);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.jewel.Alert', org.apache.royale.jewel.Alert);


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Alert.YES = 0x1;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Alert.NO = 0x2;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Alert.OK = 0x4;


/**
 * @export
 * @nocollapse
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Alert.CANCEL = 0x8;


/**
 * @private
 * @type {HTMLDialogElement}
 */
org.apache.royale.jewel.Alert.prototype.org_apache_royale_jewel_Alert_dialog;


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @royaleignorecoercion HTMLDialogElement
 * @protected
 * @override
 */
org.apache.royale.jewel.Alert.prototype.createElement = function() {
  this.org_apache_royale_jewel_Alert_dialog = org.apache.royale.html.util.addElementToWrapper(this, 'dialog');
  return this.element;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.jewel.Alert.prototype.org_apache_royale_jewel_Alert_lockDialogCreation = false;


/**
 *  This function make the dialog be added only once to document.body if parent is not
 *  provided (null) or to parent if indicated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @private
 * @param {Object=} parent
 */
org.apache.royale.jewel.Alert.prototype.org_apache_royale_jewel_Alert_prepareAlert = function(parent) {
  parent = typeof parent !== 'undefined' ? parent : null;
  if (!this.org_apache_royale_jewel_Alert_lockDialogCreation) {
    this.org_apache_royale_jewel_Alert_lockDialogCreation = true;
    if (parent != null) {
      parent.addElement(this);
    } else {
      var /** @type {HTMLElement} */ body = document.getElementsByTagName('body')[0];
      body.appendChild(this.element);
    }
    this.addedToParent();
    if (!("showModal" in this.org_apache_royale_jewel_Alert_dialog)) {
      dialogPolyfill.registerDialog(this.org_apache_royale_jewel_Alert_dialog);
    }
    document.body.classList.add("viewport");
  }
};


/**
 *  This static method is a convenience function to quickly create and display an Alert. The
 *  text and parent paramters are required, the others will default.
 *
 *  @asparam String message The message content of the Alert.
 *  @asparam String title An optional title for the Alert.
 *  @asparam uint flags Identifies which buttons to display in the alert.
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {string} message
 * @param {string=} title
 * @param {number=} flags
 * @param {Object=} parent
 * @param {boolean=} modal
 * @return {org.apache.royale.jewel.Alert}
 */
org.apache.royale.jewel.Alert.show = function(message, title, flags, parent, modal) {
  title = typeof title !== 'undefined' ? title : "";
  flags = typeof flags !== 'undefined' ? flags : org.apache.royale.jewel.Alert.OK;
  parent = typeof parent !== 'undefined' ? parent : null;
  modal = typeof modal !== 'undefined' ? modal : true;
  var /** @type {org.apache.royale.jewel.Alert} */ alert = new org.apache.royale.jewel.Alert();
  alert.message = message;
  alert.title = title;
  alert.flags = flags;
  if (modal)
    alert.showModal(parent);
  else
    alert.show(parent);
  return alert;
};


/**
 *  Shows the Alert modal anchored to the given parent object which is usally a root component such
 *  as a UIView or body if null
 * 
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {Object=} parent
 */
org.apache.royale.jewel.Alert.prototype.showModal = function(parent) {
  parent = typeof parent !== 'undefined' ? parent : null;
  this.org_apache_royale_jewel_Alert_prepareAlert(parent);
  
  this.org_apache_royale_jewel_Alert_dialog.showModal();
};


/**
 *  Shows the Alert non modal anchored to the given parent object which is usally a root component such
 *  as a UIView or body if null
 * 
 *  @asparam Object parent The object that hosts the pop-up.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {Object=} parent
 */
org.apache.royale.jewel.Alert.prototype.show = function(parent) {
  parent = typeof parent !== 'undefined' ? parent : null;
  this.org_apache_royale_jewel_Alert_prepareAlert(parent);
  
  this.org_apache_royale_jewel_Alert_dialog.show();
};


/**
 *  Closes the dialog element.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @export
 * @param {number=} buttonFlag
 */
org.apache.royale.jewel.Alert.prototype.close = function(buttonFlag) {
  buttonFlag = typeof buttonFlag !== 'undefined' ? buttonFlag : 0x000004;
  var /** @type {org.apache.royale.events.CloseEvent} */ closeEvent = new org.apache.royale.events.CloseEvent("close", false, false, buttonFlag);
  this.dispatchEvent(closeEvent);
};


org.apache.royale.jewel.Alert.prototype.get__title = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).title;
};


org.apache.royale.jewel.Alert.prototype.set__title = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).title = value;
};


org.apache.royale.jewel.Alert.prototype.get__message = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).message;
};


org.apache.royale.jewel.Alert.prototype.set__message = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).message = value;
};


org.apache.royale.jewel.Alert.prototype.get__flags = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).flags;
};


org.apache.royale.jewel.Alert.prototype.set__flags = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IAlertModel, true).flags = value;
};


Object.defineProperties(org.apache.royale.jewel.Alert.prototype, /** @lends {org.apache.royale.jewel.Alert.prototype} */ {
/**
  * @export
  * @type {string} */
title: {
get: org.apache.royale.jewel.Alert.prototype.get__title,
set: org.apache.royale.jewel.Alert.prototype.set__title},
/**
  * @export
  * @type {string} */
message: {
get: org.apache.royale.jewel.Alert.prototype.get__message,
set: org.apache.royale.jewel.Alert.prototype.set__message},
/**
  * @export
  * @type {number} */
flags: {
get: org.apache.royale.jewel.Alert.prototype.get__flags,
set: org.apache.royale.jewel.Alert.prototype.set__flags}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.jewel.Alert.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Alert', qName: 'org.apache.royale.jewel.Alert', kind: 'class' }], interfaces: [org.apache.royale.core.IPopUp] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.jewel.Alert.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'title': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Alert'},
        'message': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Alert'},
        'flags': { type: 'uint', access: 'readwrite', declaredBy: 'org.apache.royale.jewel.Alert'}
      };
    },
    methods: function () {
      return {
        'Alert': { type: '', declaredBy: 'org.apache.royale.jewel.Alert'},
        '|show': { type: 'org.apache.royale.jewel.Alert', declaredBy: 'org.apache.royale.jewel.Alert', parameters: function () { return [ 'String', false ,'String', true ,'uint', true ,'Object', true ,'Boolean', true ]; }},
        'showModal': { type: 'void', declaredBy: 'org.apache.royale.jewel.Alert', parameters: function () { return [ 'Object', true ]; }},
        'show': { type: 'void', declaredBy: 'org.apache.royale.jewel.Alert', parameters: function () { return [ 'Object', true ]; }},
        'close': { type: 'void', declaredBy: 'org.apache.royale.jewel.Alert', parameters: function () { return [ 'uint', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.jewel.Alert.prototype.ROYALE_COMPILE_FLAGS = 10;