/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/GraphicsBitmapFill.as
 * org.apache.royale.display.GraphicsBitmapFill
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.GraphicsBitmapFill');

goog.require('org.apache.royale.display.BitmapData');
goog.require('org.apache.royale.display.Graphics');
goog.require('org.apache.royale.geom.Matrix');
goog.require('org.apache.royale.display.IGraphicsData');
goog.require('org.apache.royale.display.IGraphicsFill');



/**
 * @constructor
 * @implements {org.apache.royale.display.IGraphicsFill}
 * @implements {org.apache.royale.display.IGraphicsData}
 * @param {org.apache.royale.display.BitmapData=} bitmapData
 * @param {org.apache.royale.geom.Matrix=} matrix
 * @param {boolean=} repeat
 * @param {boolean=} smooth
 */
org.apache.royale.display.GraphicsBitmapFill = function(bitmapData, matrix, repeat, smooth) {
  bitmapData = typeof bitmapData !== 'undefined' ? bitmapData : null;
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  repeat = typeof repeat !== 'undefined' ? repeat : true;
  smooth = typeof smooth !== 'undefined' ? smooth : false;
  this.bitmapData = bitmapData;
  this.matrix = matrix;
  this.repeat = repeat;
  this.smooth = smooth;
};


/**
 * @private
 * @type {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsBitmapFill._defaultMatrix;


/**
 * @type {org.apache.royale.display.BitmapData}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.bitmapData;


/**
 * @type {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.matrix;


/**
 * @type {boolean}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.repeat;


/**
 * @type {boolean}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.smooth;


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.apply = function(graphics, element) {
  var /** @type {SVGPatternElement} */ fillElement = this.org_apache_royale_display_GraphicsBitmapFill_configurePatternElement(graphics, graphics.makeBitmapPaint(this.bitmapData, this.smooth));
  element.setAttributeNS(null, 'fill', 'url(#' + fillElement.getAttribute('id') + ')');
};


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 * @return {SVGPathElement}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.applyStroke = function(graphics, element) {
  if (element.getAttributeNS(null, 'stroke-opacity') != null) {
    element.setAttributeNS(null, 'stroke-opacity', null);
  }
  var /** @type {SVGPatternElement} */ strokeElement = this.org_apache_royale_display_GraphicsBitmapFill_configurePatternElement(graphics, graphics.makeBitmapPaint(this.bitmapData, this.smooth));
  element.setAttributeNS(null, 'stroke', 'url(#' + strokeElement.getAttribute('id') + ')');
  return element;
};


/**
 * @private
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPatternElement} patternElement
 * @return {SVGPatternElement}
 */
org.apache.royale.display.GraphicsBitmapFill.prototype.org_apache_royale_display_GraphicsBitmapFill_configurePatternElement = function(graphics, patternElement) {
  var /** @type {string} */ w;
  var /** @type {string} */ h;
  if (this.repeat) {
    w = this.bitmapData.width.toString();
    h = this.bitmapData.height.toString();
  } else {
    w = h = '100%';
  }
  patternElement.setAttributeNS(null, 'width', w);
  patternElement.setAttributeNS(null, 'height', h);
  if (this.matrix) {
    var /** @type {string} */ matrixString = 'matrix(' + this.matrix.a + ',' + this.matrix.b + ',' + this.matrix.c + ',' + this.matrix.d + ',' + this.matrix.tx + ',' + this.matrix.ty + ')';
    patternElement.setAttributeNS(null, 'patternTransform', matrixString);
  }
  return patternElement;
};