/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/MultiSelectionDragImageBead.as
 * org.apache.royale.html.beads.MultiSelectionDragImageBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.MultiSelectionDragImageBead');

goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.core.IBeadView');
goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IItemRendererOwnerView');
goog.require('org.apache.royale.core.IMultiSelectionModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IStrandWithModel');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.Lookalike');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.DragEvent');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.Container');
goog.require('org.apache.royale.html.beads.IListView');
goog.require('org.apache.royale.html.beads.controllers.DragMouseController');
goog.require('org.apache.royale.html.beads.layouts.HorizontalLayout');
goog.require('org.apache.royale.html.beads.layouts.VerticalLayout');
goog.require('org.apache.royale.utils.getParentOrSelfByType');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead = function() {
  org.apache.royale.html.beads.MultiSelectionDragImageBead.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.MultiSelectionDragImageBead, org.apache.royale.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand;


/**
 * Creates an example/temporary component to be dragged and returns it.
 *
 * @asreturn UIBase The "dragImage" to use.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 *  @royaleignorecoercion org.apache.royale.core.IItemRendererOwnerView
 *  @royaleignorecoercion org.apache.royale.html.beads.IListView
 * @protected
 * @return {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.createDragImage = function() {
  var /** @type {org.apache.royale.html.Container} */ dragImage = new org.apache.royale.html.Container();
  var /** @type {org.apache.royale.core.IBead} */ layoutBead = this.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand.getBeadByType(org.apache.royale.core.IBeadLayout);
  if (org.apache.royale.utils.Language.is(layoutBead, org.apache.royale.html.beads.layouts.VerticalLayout)) {
    dragImage.addBead(new org.apache.royale.html.beads.layouts.VerticalLayout());
  } else {
    dragImage.addBead(new org.apache.royale.html.beads.layouts.HorizontalLayout());
  }
  var /** @type {Object} */ itemRendererOwnerView = this.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand.getBeadByType(org.apache.royale.core.IBeadView).dataGroup;
  var /** @type {Array} */ selectedIndices = this.org_apache_royale_html_beads_MultiSelectionDragImageBead_model.selectedIndices;
  for (var /** @type {number} */ i = 0; i < selectedIndices.length; i++) {
    var /** @type {org.apache.royale.core.IItemRenderer} */ ir = itemRendererOwnerView.getItemRendererForIndex((selectedIndices[i]) >> 0);
    var /** @type {org.apache.royale.core.UIBase} */ lookalike = new org.apache.royale.core.Lookalike(ir);
    lookalike.width = ir.width;
    lookalike.height = ir.height;
    dragImage.addElement(lookalike);
  }
  dragImage.className = "DragImage";
  dragImage.element.style.position = 'absolute';
  dragImage.element.style.cursor = 'pointer';
  return dragImage;
};


/**
 * @asprivate
 *  @royaleignorecoercion org.apache.royale.core.IChild
 *  @royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.org_apache_royale_html_beads_MultiSelectionDragImageBead_handleDragStart = function(event) {
  var /** @type {Object} */ relatedObject = event.relatedObject;
  var /** @type {Object} */ itemRenderer = org.apache.royale.utils.getParentOrSelfByType(relatedObject, org.apache.royale.core.IItemRenderer);
  if (itemRenderer && !this.org_apache_royale_html_beads_MultiSelectionDragImageBead_model.selectedItems) {
    this.org_apache_royale_html_beads_MultiSelectionDragImageBead_model.selectedItems = [itemRenderer.data];
  }
  if (this.org_apache_royale_html_beads_MultiSelectionDragImageBead_model.selectedItems && (itemRenderer && this.org_apache_royale_html_beads_MultiSelectionDragImageBead_model.selectedItems.indexOf(itemRenderer.data) > -1)) {
    org.apache.royale.html.beads.controllers.DragMouseController.dragImage = this.createDragImage();
  }
};


/**
 * @nocollapse
 * @export
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.strand;


org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand = value;
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_START, org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_MultiSelectionDragImageBead_handleDragStart, this, 'org_apache_royale_html_beads_MultiSelectionDragImageBead_handleDragStart'));
};


/**
 * @type {org.apache.royale.core.IMultiSelectionModel}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.org_apache_royale_html_beads_MultiSelectionDragImageBead_model;


org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.get__org_apache_royale_html_beads_MultiSelectionDragImageBead_model = function() {
  return this.org_apache_royale_html_beads_MultiSelectionDragImageBead__strand.model;
};


Object.defineProperties(org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype, /** @lends {org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype} */ {
/**
 * @type {org.apache.royale.core.IStrand}
 */
strand: {
set: org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.set__strand},
/**
 * @type {org.apache.royale.core.IMultiSelectionModel}
 */
org_apache_royale_html_beads_MultiSelectionDragImageBead_model: {
get: org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.get__org_apache_royale_html_beads_MultiSelectionDragImageBead_model}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'MultiSelectionDragImageBead', qName: 'org.apache.royale.html.beads.MultiSelectionDragImageBead', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.MultiSelectionDragImageBead'}
      };
    },
    methods: function () {
      return {
        'MultiSelectionDragImageBead': { type: '', declaredBy: 'org.apache.royale.html.beads.MultiSelectionDragImageBead'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.MultiSelectionDragImageBead.prototype.ROYALE_COMPILE_FLAGS = 10;