/**
 * Generated by Apache Royale Compiler from org\apache\royale\collections\LazyCollection.as
 * org.apache.royale.collections.LazyCollection
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.LazyCollection');

goog.require('org.apache.royale.collections.converters.IItemConverter');
goog.require('org.apache.royale.collections.parsers.IInputParser');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.collections.ICollection');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.collections.ICollection}
 */
org.apache.royale.collections.LazyCollection = function() {
  org.apache.royale.collections.LazyCollection.base(this, 'constructor');
};
goog.inherits(org.apache.royale.collections.LazyCollection, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.LazyCollection', org.apache.royale.collections.LazyCollection);


/**
 * @private
 * @type {org.apache.royale.collections.parsers.IInputParser}
 */
org.apache.royale.collections.LazyCollection.prototype.org_apache_royale_collections_LazyCollection__inputParser;


/**
 * @private
 * @type {org.apache.royale.collections.converters.IItemConverter}
 */
org.apache.royale.collections.LazyCollection.prototype.org_apache_royale_collections_LazyCollection__itemConverter;


/**
 * @private
 * @type {string}
 */
org.apache.royale.collections.LazyCollection.prototype.org_apache_royale_collections_LazyCollection__id;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.collections.LazyCollection.prototype.org_apache_royale_collections_LazyCollection__strand;


/**
 * @protected
 * @type {Array}
 */
org.apache.royale.collections.LazyCollection.prototype.rawData;


/**
 * @protected
 * @type {Array}
 */
org.apache.royale.collections.LazyCollection.prototype.data;


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.collections.LazyCollection.prototype.org_apache_royale_collections_LazyCollection_completeHandler = function(event) {
  this.rawData = this.inputParser.parseItems(this.org_apache_royale_collections_LazyCollection__strand["data"]);
  this.data = new Array(this.rawData.length);
  this.dispatchEvent(event);
};


/**
 *  Fetches an item from the collection, converting it first if necessary.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.LazyCollection.prototype.getItemAt = function(index) {
  if (this.data[index] == undefined) {
    this.data[index] = this.itemConverter.convertItem(this.rawData[index]);
  }
  return this.data[index];
};


org.apache.royale.collections.LazyCollection.prototype.get__inputParser = function() {
  return this.org_apache_royale_collections_LazyCollection__inputParser;
};


org.apache.royale.collections.LazyCollection.prototype.set__inputParser = function(value) {
  if (this.org_apache_royale_collections_LazyCollection__inputParser != value) {
    this.org_apache_royale_collections_LazyCollection__inputParser = value;
    this.dispatchEvent(new org.apache.royale.events.Event("inputParserChanged"));
  }
};


org.apache.royale.collections.LazyCollection.prototype.get__itemConverter = function() {
  return this.org_apache_royale_collections_LazyCollection__itemConverter;
};


org.apache.royale.collections.LazyCollection.prototype.set__itemConverter = function(value) {
  if (this.org_apache_royale_collections_LazyCollection__itemConverter != value) {
    this.org_apache_royale_collections_LazyCollection__itemConverter = value;
    this.dispatchEvent(new org.apache.royale.events.Event("itemConverterChanged"));
  }
};


org.apache.royale.collections.LazyCollection.prototype.get__id = function() {
  return this.org_apache_royale_collections_LazyCollection__id;
};


org.apache.royale.collections.LazyCollection.prototype.set__id = function(value) {
  if (this.org_apache_royale_collections_LazyCollection__id != value) {
    this.org_apache_royale_collections_LazyCollection__id = value;
    this.dispatchEvent(new org.apache.royale.events.Event("idChanged"));
  }
};


org.apache.royale.collections.LazyCollection.prototype.set__strand = function(value) {
  this.org_apache_royale_collections_LazyCollection__strand = value;
  
  this.org_apache_royale_collections_LazyCollection__strand.addEventListener("complete", org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_LazyCollection_completeHandler, this, 'completeHandler'));
};


org.apache.royale.collections.LazyCollection.prototype.get__length = function() {
  return this.rawData ? this.rawData.length : 0;
};


Object.defineProperties(org.apache.royale.collections.LazyCollection.prototype, /** @lends {org.apache.royale.collections.LazyCollection.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.collections.parsers.IInputParser} */
inputParser: {
get: org.apache.royale.collections.LazyCollection.prototype.get__inputParser,
set: org.apache.royale.collections.LazyCollection.prototype.set__inputParser},
/**
  * @export
  * @type {org.apache.royale.collections.converters.IItemConverter} */
itemConverter: {
get: org.apache.royale.collections.LazyCollection.prototype.get__itemConverter,
set: org.apache.royale.collections.LazyCollection.prototype.set__itemConverter},
/**
  * @export
  * @type {string} */
id: {
get: org.apache.royale.collections.LazyCollection.prototype.get__id,
set: org.apache.royale.collections.LazyCollection.prototype.set__id},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.collections.LazyCollection.prototype.set__strand},
/**
  * @export
  * @type {number} */
length: {
get: org.apache.royale.collections.LazyCollection.prototype.get__length}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.LazyCollection.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'LazyCollection', qName: 'org.apache.royale.collections.LazyCollection', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.collections.ICollection] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.LazyCollection.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'inputParser': { type: 'org.apache.royale.collections.parsers.IInputParser', access: 'readwrite', declaredBy: 'org.apache.royale.collections.LazyCollection'},
        'itemConverter': { type: 'org.apache.royale.collections.converters.IItemConverter', access: 'readwrite', declaredBy: 'org.apache.royale.collections.LazyCollection'},
        'id': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.collections.LazyCollection'},
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.collections.LazyCollection'},
        'length': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.collections.LazyCollection'}
      };
    },
    methods: function () {
      return {
        'LazyCollection': { type: '', declaredBy: 'org.apache.royale.collections.LazyCollection'},
        'getItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.LazyCollection', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }}
      };
    },
    metadata: function () { return [  ]; }
  };
};