/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\beads\DataContainerView.as
 * org.apache.royale.html.beads.DataContainerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.DataContainerView');

goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.IDataProviderItemRendererMapper');
goog.require('org.apache.royale.core.IDataProviderModel');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IItemRendererClassFactory');
goog.require('org.apache.royale.core.IItemRendererParent');
goog.require('org.apache.royale.core.IParent');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.ItemAddedEvent');
goog.require('org.apache.royale.events.ItemRemovedEvent');
goog.require('org.apache.royale.html.beads.ContainerView');
goog.require('org.apache.royale.html.supportClasses.DataItemRenderer');
goog.require('org.apache.royale.utils.loadBeadFromValuesManager');
goog.require('org.apache.royale.html.beads.IListView');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.html.beads.ContainerView}
 * @implements {org.apache.royale.html.beads.IListView}
 * @implements {org.apache.royale.core.IItemRendererParent}
 */
org.apache.royale.html.beads.DataContainerView = function() {
  org.apache.royale.html.beads.DataContainerView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.DataContainerView, org.apache.royale.html.beads.ContainerView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.DataContainerView', org.apache.royale.html.beads.DataContainerView);


/**
 * @protected
 * @type {org.apache.royale.core.IDataProviderModel}
 */
org.apache.royale.html.beads.DataContainerView.prototype.dataModel;


/**
 * @royaleignorecoercion org.apache.royale.core.IDataProviderModel
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataContainerView.prototype.beadsAddedHandler = function(event) {
  this.dataModel = this._strand.getBeadByType(org.apache.royale.core.IDataProviderModel);
  this.host.addEventListener("itemsCreated", org.apache.royale.utils.Language.closure(this.itemsCreatedHandler, this, 'itemsCreatedHandler'));
  this.dataModel.addEventListener("dataProviderChanged", org.apache.royale.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataContainerView.prototype.itemsCreatedHandler = function(event) {
  this.host.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.DataContainerView.prototype.dataProviderChangeHandler = function(event) {
  this.performLayout(event);
  
};


/**
 * @copy org.apache.royale.core.IItemRendererParent#addItemRenderer()
 * @asprivate
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 * @param {org.apache.royale.core.IItemRenderer} renderer
 * @param {boolean} dispatchAdded
 */
org.apache.royale.html.beads.DataContainerView.prototype.addItemRenderer = function(renderer, dispatchAdded) {
  this.contentView.addElement(renderer, dispatchAdded);
  this.org_apache_royale_html_beads_DataContainerView_dispatchItemAdded(renderer);
};


/**
 * @copy org.apache.royale.core.IItemRendererParent#addItemRendererAt()
 * @asprivate
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 * @param {org.apache.royale.core.IItemRenderer} renderer
 * @param {number} index
 */
org.apache.royale.html.beads.DataContainerView.prototype.addItemRendererAt = function(renderer, index) {
  this.contentView.addElementAt(renderer, index, true);
  this.org_apache_royale_html_beads_DataContainerView_dispatchItemAdded(renderer);
};


/**
 * @private
 * @param {org.apache.royale.core.IItemRenderer} renderer
 */
org.apache.royale.html.beads.DataContainerView.prototype.org_apache_royale_html_beads_DataContainerView_dispatchItemAdded = function(renderer) {
  var /** @type {org.apache.royale.events.ItemAddedEvent} */ newEvent = new org.apache.royale.events.ItemAddedEvent("itemAdded");
  newEvent.item = renderer;
  this.host.dispatchEvent(newEvent);
};


/**
 * @copy org.apache.royale.core.IItemRendererParent#removeItemRenderer()
 * @asprivate
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 * @param {org.apache.royale.core.IItemRenderer} renderer
 */
org.apache.royale.html.beads.DataContainerView.prototype.removeItemRenderer = function(renderer) {
  this.contentView.removeElement(renderer);
  var /** @type {org.apache.royale.events.ItemRemovedEvent} */ newEvent = new org.apache.royale.events.ItemRemovedEvent("itemRemoved");
  newEvent.item = renderer;
  this.host.dispatchEvent(newEvent);
};


/**
 * @copy org.apache.royale.core.IItemRendererParent#removeAllItemRenderers()
 * @asprivate
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 */
org.apache.royale.html.beads.DataContainerView.prototype.removeAllItemRenderers = function() {
  while (this.contentView.numElements > 0) {
    var /** @type {org.apache.royale.core.IChild} */ child = this.contentView.getElementAt(0);
    this.contentView.removeElement(child);
  }
};


/**
 *  @copy org.apache.royale.core.IItemRendererParent#getItemRendererForIndex()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * 	@royaleignorecoercion org.apache.royale.core.IItemRenderer
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.html.beads.DataContainerView.prototype.getItemRendererForIndex = function(index) {
  if (index < 0 || index >= org.apache.royale.utils.Language.as(this.contentView, org.apache.royale.core.IParent).numElements)
    return null;
  return org.apache.royale.utils.Language.as(this.contentView, org.apache.royale.core.IParent).getElementAt(index);
};


/**
 *  @copy org.apache.royale.core.IItemRendererParent#getItemRendererAt()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * 	@royaleignorecoercion org.apache.royale.core.IItemRenderer
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.html.beads.DataContainerView.prototype.getItemRendererAt = function(index) {
  if (index < 0 || index >= this.contentView.numElements)
    return null;
  return this.contentView.getElementAt(index);
};


/**
 *  Refreshes the itemRenderers. Useful after a size change by the data group.
 *
 *  @copy org.apache.royale.core.IItemRendererParent#updateAllItemRenderers()
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * 	@royaleignorecoercion org.apache.royale.html.supportClasses.DataItemRenderer
 *  @royaleignorecoercion org.apache.royale.core.IParent
 * @export
 */
org.apache.royale.html.beads.DataContainerView.prototype.updateAllItemRenderers = function() {
  var /** @type {number} */ n = this.contentView.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {Object} */ renderer = this.getItemRendererForIndex(i);
    if (renderer) {
      renderer.setWidth(this.host.width, true);
      renderer.adjustSize();
    }
  }
};


org.apache.royale.html.beads.DataContainerView.prototype.set__strand = function(value) {
  this._strand = value;
  org.apache.royale.html.beads.DataContainerView.superClass_.set__strand.apply(this, [ value] );
  org.apache.royale.utils.loadBeadFromValuesManager(org.apache.royale.core.IDataProviderItemRendererMapper, "iDataProviderItemRendererMapper", value);
  org.apache.royale.utils.loadBeadFromValuesManager(org.apache.royale.core.IItemRendererClassFactory, "iItemRendererClassFactory", value);
  this.host.addEventListener("beadsAdded", org.apache.royale.utils.Language.closure(this.beadsAddedHandler, this, 'beadsAddedHandler'));
};


org.apache.royale.html.beads.DataContainerView.prototype.get__dataGroup = function() {
  return this;
};


org.apache.royale.html.beads.DataContainerView.prototype.get__numItemRenderers = function() {
  return this.contentView.numElements;
};


Object.defineProperties(org.apache.royale.html.beads.DataContainerView.prototype, /** @lends {org.apache.royale.html.beads.DataContainerView.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.DataContainerView.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.core.IItemRendererParent} */
dataGroup: {
get: org.apache.royale.html.beads.DataContainerView.prototype.get__dataGroup},
/**
  * @export
  * @type {number} */
numItemRenderers: {
get: org.apache.royale.html.beads.DataContainerView.prototype.get__numItemRenderers}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.DataContainerView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataContainerView', qName: 'org.apache.royale.html.beads.DataContainerView', kind: 'class' }], interfaces: [org.apache.royale.html.beads.IListView, org.apache.royale.core.IItemRendererParent] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.DataContainerView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.DataContainerView'},
        'dataGroup': { type: 'org.apache.royale.core.IItemRendererParent', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.DataContainerView'},
        'numItemRenderers': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.DataContainerView'}
      };
    },
    methods: function () {
      return {
        'DataContainerView': { type: '', declaredBy: 'org.apache.royale.html.beads.DataContainerView'},
        'addItemRenderer': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataContainerView', parameters: function () { return [  { index: 1, type: 'org.apache.royale.core.IItemRenderer', optional: false },{ index: 2, type: 'Boolean', optional: false } ]; }},
        'addItemRendererAt': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataContainerView', parameters: function () { return [  { index: 1, type: 'org.apache.royale.core.IItemRenderer', optional: false },{ index: 2, type: 'int', optional: false } ]; }},
        'removeItemRenderer': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataContainerView', parameters: function () { return [  { index: 1, type: 'org.apache.royale.core.IItemRenderer', optional: false } ]; }},
        'removeAllItemRenderers': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataContainerView'},
        'getItemRendererForIndex': { type: 'org.apache.royale.core.IItemRenderer', declaredBy: 'org.apache.royale.html.beads.DataContainerView', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }},
        'getItemRendererAt': { type: 'org.apache.royale.core.IItemRenderer', declaredBy: 'org.apache.royale.html.beads.DataContainerView', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }},
        'updateAllItemRenderers': { type: 'void', declaredBy: 'org.apache.royale.html.beads.DataContainerView'}
      };
    }
  };
};