/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="package-js", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageJSMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(defaultValue="javascript")
    private String javascriptOutputDirectoryName;
    @Parameter(defaultValue="${project.artifactId}-${project.version}.war")
    private String warOutputFileName;
    @Parameter
    protected boolean debug = false;
    @Component
    protected MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File warSourceDirectory = new File(this.outputDirectory, this.javascriptOutputDirectoryName);
        if ((warSourceDirectory = new File(new File(warSourceDirectory, "bin"), this.debug ? "js-debug" : "js-release")).exists()) {
            File warTargetFile = new File(this.outputDirectory, this.warOutputFileName);
            if (warTargetFile.exists() && !warTargetFile.delete()) {
                throw new MojoExecutionException("Could not delete existing war file at " + warSourceDirectory.getPath());
            }
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(warTargetFile));
                this.addDirectoryToZip(warSourceDirectory, warSourceDirectory, zipOutputStream);
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating war archive", (Exception)e);
            }
            if (warTargetFile.exists()) {
                this.projectHelper.attachArtifact(this.project, "war", null, warTargetFile);
            }
        }
    }

    private void addDirectoryToZip(File zipRootDirectory, File currentDirectory, ZipOutputStream zipOutputStream) throws IOException {
        File[] directoryContent = currentDirectory.listFiles();
        if (directoryContent != null) {
            for (File file : directoryContent) {
                if (file.isDirectory()) {
                    this.addDirectoryToZip(zipRootDirectory, file, zipOutputStream);
                    continue;
                }
                String relativePath = zipRootDirectory.toURI().relativize(currentDirectory.toURI()).getPath();
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                ZipEntry zipEntry = new ZipEntry(relativePath + file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream in = new FileInputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }
}

