/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;
import org.apache.royale.maven.Namespace;

@Mojo(name="compile-js", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CompileJSMojo
extends BaseMojo {
    @Parameter(defaultValue="${project.artifactId}-${project.version}-js.swc")
    private String outputFileName;
    @Parameter(defaultValue="false")
    private boolean skipSwc;
    @Parameter(defaultValue="false")
    private boolean skipJS;
    @Component
    private MavenProjectHelper projectHelper;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "COMPC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "compile-js-config.xml";
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.outputFileName);
    }

    @Override
    protected boolean skip() {
        return this.skipSwc || this.skipJS;
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        List<String> args = super.getCompilerArgs(configFile);
        args.add("-compiler.targets=SWF,JSRoyale");
        args.add("-compiler.strict-xml=true");
        return args;
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getOutput().exists()) {
            this.projectHelper.attachArtifact(this.project, this.getOutput(), "js");
        }
    }

    @Override
    protected List<Namespace> getNamespaces() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        for (Namespace namespace : super.getNamespaces()) {
            if (!namespace.getType().equals("default") && !namespace.getType().equals("js")) continue;
            namespaces.add(namespace);
        }
        return namespaces;
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "true"));
        defines.add(new Define("COMPILE::SWF", "false"));
        return defines;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        String classifier = library.getClassifier();
        return classifier == null && !"runtime".equalsIgnoreCase(library.getScope());
    }

    @Override
    protected boolean includeLibraryJS(Artifact library) {
        String classifier = library.getClassifier();
        return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
    }

    @Override
    protected boolean includeLibrarySWF(Artifact library) {
        String classifier = library.getClassifier();
        return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
    }

    private void createEmptySwc(File outputFile) throws MojoExecutionException {
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + outputFile.getParent());
        }
        try {
            OutputStream stream = new FileOutputStream(outputFile);
            stream = new BufferedOutputStream(stream);
            ZipOutputStream zipStream = new ZipOutputStream(stream);
            ZipEntry entry = new ZipEntry("catalog.xml");
            zipStream.putNextEntry(entry);
            byte[] dummyCatalog = "<?xml version=\"1.0\" ?>\n<swc xmlns=\"http://www.adobe.com/flash/swccatalog/9\">\n    <versions>\n        <swc version=\"1.2\"/>\n        <compiler name=\"Apache Royale: Compiler: Transpiler\" version=\"0.8\" build=\"0-SNAPSHOT\"/>\n    </versions>\n    <features>\n    </features>\n    <libraries>\n    </libraries>\n</swc>".getBytes();
            zipStream.write(dummyCatalog);
            zipStream.closeEntry();
            zipStream.close();
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Could not create empty zip file at " + outputFile.getPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create empty zip file at " + outputFile.getPath());
        }
    }
}

