/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;
import org.apache.velocity.VelocityContext;

@Mojo(name="compile-app", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CompileAppMojo
extends BaseMojo {
    @Parameter
    private String mainClass;
    @Parameter(defaultValue="${project.artifactId}-${project.version}.swf")
    private String flashOutputFileName;
    @Parameter(defaultValue="javascript")
    private String javascriptOutputDirectoryName;
    @Parameter(defaultValue="namespaces")
    protected String namespaceDirectory;
    @Parameter
    protected String htmlTemplate;
    @Parameter
    protected String targets = "SWF,JSRoyale";
    @Parameter(defaultValue="true")
    protected boolean removeCirculars;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "MXMLC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "compile-app-config.xml";
    }

    @Override
    protected VelocityContext getVelocityContext() throws MojoExecutionException {
        VelocityContext context = super.getVelocityContext();
        context.put("removeCirculars", (Object)this.removeCirculars);
        context.put("htmlTemplate", (Object)this.htmlTemplate);
        return context;
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.flashOutputFileName);
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        if (this.mainClass == null) {
            throw new MojoExecutionException("The mainClass has to be declared for SWF type modules.");
        }
        String mainClassPath = this.getSourcePath(this.mainClass);
        if (mainClassPath == null) {
            throw new MojoExecutionException("Could not find main class");
        }
        List<String> args = super.getCompilerArgs(configFile);
        File jsOutput = new File(this.outputDirectory, this.javascriptOutputDirectoryName);
        args.add("-js-output=" + jsOutput.getAbsolutePath());
        args.add("-compiler.targets=" + this.targets);
        args.add(mainClassPath);
        return args;
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getOutput().exists()) {
            this.project.getArtifact().setFile(this.getOutput());
        }
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "AUTO"));
        defines.add(new Define("COMPILE::SWF", "AUTO"));
        return defines;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        String classifier = library.getClassifier();
        return classifier == null && !"runtime".equalsIgnoreCase(library.getScope());
    }

    @Override
    protected boolean includeLibraryJS(Artifact library) {
        String classifier = library.getClassifier();
        return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
    }

    @Override
    protected boolean includeLibrarySWF(Artifact library) {
        String classifier = library.getClassifier();
        return "swf".equalsIgnoreCase(classifier) || classifier == null && "runtime".equalsIgnoreCase(library.getScope());
    }
}

