/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;
import org.apache.royale.maven.Namespace;

@Mojo(name="compile-as", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CompileASMojo
extends BaseMojo {
    @Parameter(defaultValue="${project.artifactId}-${project.version}-swf.swc")
    private String outputFileName;
    @Parameter(defaultValue="false")
    private boolean skipSwc;
    @Parameter(defaultValue="false")
    private boolean skipAS;
    @Component
    private MavenProjectHelper projectHelper;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "COMPC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "compile-swf-config.xml";
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.outputFileName);
    }

    @Override
    protected boolean skip() {
        return this.skipSwc || this.skipAS;
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getOutput().exists()) {
            this.project.getArtifact().setFile(this.getOutput());
            this.projectHelper.attachArtifact(this.project, this.getOutput(), "swf");
        }
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        List<String> args = super.getCompilerArgs(configFile);
        args.add("-compiler.targets=SWF,JSRoyale");
        args.add("-compiler.strict-xml=true");
        return args;
    }

    @Override
    protected List<Namespace> getNamespaces() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        for (Namespace namespace : super.getNamespaces()) {
            if (!namespace.getType().equals("default") && !namespace.getType().equals("as")) continue;
            namespaces.add(namespace);
        }
        return namespaces;
    }

    @Override
    protected List<Namespace> getNamespacesJS() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        for (Namespace namespace : super.getNamespaces()) {
            if (!namespace.getType().equals("default") && !namespace.getType().equals("js")) continue;
            namespaces.add(namespace);
        }
        return namespaces;
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "AUTO"));
        defines.add(new Define("COMPILE::SWF", "AUTO"));
        return defines;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        String classifier = library.getClassifier();
        return classifier == null && !"runtime".equalsIgnoreCase(library.getScope());
    }

    @Override
    protected boolean includeLibraryJS(Artifact library) {
        String classifier = library.getClassifier();
        return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
    }

    @Override
    protected boolean includeLibrarySWF(Artifact library) {
        String classifier = library.getClassifier();
        return "swf".equalsIgnoreCase(classifier) || classifier == null && "runtime".equalsIgnoreCase(library.getScope());
    }
}

