/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml.royale;

import java.util.ArrayList;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLEventSpecifier;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLNodeSpecifier;

public class MXMLDescriptorSpecifier
extends MXMLNodeSpecifier {
    public MXMLDescriptorSpecifier childrenSpecifier;
    public ArrayList<MXMLDescriptorSpecifier> propertySpecifiers;
    public ArrayList<MXMLEventSpecifier> eventSpecifiers = new ArrayList();
    public boolean hasArray;
    public boolean hasObject;
    public String id;
    public boolean hasLocalId;
    public String effectiveId;
    public boolean isTopNode;
    public boolean isProperty;
    public MXMLDescriptorSpecifier parent;
    private int currentIndent = 0;

    public MXMLDescriptorSpecifier() {
        this.propertySpecifiers = new ArrayList();
        this.valueNeedsQuotes = false;
    }

    protected String getIndent() {
        return this.getIndent(this.currentIndent);
    }

    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        if (this.parent != null) {
            sb.append(this.parent.getIndent());
        }
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    public void indentPush() {
        ++this.currentIndent;
    }

    public void indentPop() {
        if (this.currentIndent > 0) {
            --this.currentIndent;
        }
    }

    @Override
    protected void writeNewline() {
        this.write(ASEmitterTokens.NEW_LINE);
        this.write(this.getIndent(this.currentIndent));
    }

    private void outputEventSpecifier(boolean writeNewline) {
        int count = 0;
        for (MXMLEventSpecifier me : this.eventSpecifiers) {
            if (me.name == null) continue;
            ++count;
        }
        this.write(count + "");
        for (MXMLEventSpecifier me : this.eventSpecifiers) {
            this.writeDelimiter(writeNewline);
            this.write(me.output(writeNewline));
        }
    }

    private String outputPropertySpecifier(boolean writeNewline) {
        this.write(this.isProperty ? ASEmitterTokens.SINGLE_QUOTE.getToken() : "");
        this.write(this.name);
        this.write(this.isProperty ? ASEmitterTokens.SINGLE_QUOTE.getToken() : "");
        this.writeDelimiter(writeNewline);
        if (this.isProperty) {
            if (this.value != null) {
                this.write(ASEmitterTokens.TRUE);
                this.writeDelimiter(writeNewline);
                if (this.value.endsWith("\\'") && !this.value.endsWith("\\\\'")) {
                    this.value = this.value.substring(0, this.value.length() - 1) + "\\'";
                }
                this.write(this.value);
            } else {
                this.write(this.hasArray ? ASEmitterTokens.NULL : ASEmitterTokens.FALSE);
                this.writeDelimiter(writeNewline);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.indentPush();
                this.writeNewline();
                this.output(writeNewline);
                this.indentPop();
                this.writeNewline();
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            if (this.parent != null) {
                this.writeDelimiter(writeNewline);
            }
        } else {
            for (MXMLDescriptorSpecifier md : this.propertySpecifiers) {
                if (md.name == null || !md.name.equals("mxmlContent")) continue;
                this.childrenSpecifier = md;
                this.propertySpecifiers.remove(md);
                break;
            }
            if (this.id != null || this.effectiveId != null) {
                this.write(this.propertySpecifiers.size() + 1 + "");
                this.writeDelimiter(writeNewline);
                String idPropName = this.effectiveId != null ? "_id" : "id";
                this.writeSimpleDescriptor(idPropName, ASEmitterTokens.TRUE.getToken(), ASEmitterTokens.SINGLE_QUOTE.getToken() + (this.id != null ? this.id : this.effectiveId) + ASEmitterTokens.SINGLE_QUOTE.getToken(), writeNewline);
                this.writeDelimiter(writeNewline);
            } else {
                this.write(this.propertySpecifiers.size() + "");
                this.writeDelimiter(writeNewline);
            }
            this.output(writeNewline);
        }
        return this.sb.toString();
    }

    private void outputStyleSpecifier(boolean writeNewline) {
        this.write("0");
        this.writeDelimiter(writeNewline);
    }

    @Override
    public String output(boolean writeNewline) {
        if (this.isTopNode) {
            int count = 0;
            for (MXMLDescriptorSpecifier mXMLDescriptorSpecifier : this.propertySpecifiers) {
                if (mXMLDescriptorSpecifier.name == null) continue;
                ++count;
            }
            this.write(count + "");
            this.writeNewline(ASEmitterTokens.COMMA);
        }
        MXMLDescriptorSpecifier model = null;
        MXMLDescriptorSpecifier beads = null;
        for (MXMLDescriptorSpecifier md : this.propertySpecifiers) {
            if (md.name == null || !md.name.equals("model")) continue;
            model = md;
            break;
        }
        if (model != null) {
            this.write(super.outputPropertySpecifier(writeNewline));
        }
        for (MXMLDescriptorSpecifier md : this.propertySpecifiers) {
            if (md.name == null) continue;
            if (!md.name.equals("model") && !md.name.equals("beads")) {
                this.write(md.outputPropertySpecifier(writeNewline));
                continue;
            }
            if (!md.name.equals("beads")) continue;
            beads = md;
        }
        if (beads != null) {
            this.write(super.outputPropertySpecifier(writeNewline));
        }
        if (!this.isProperty) {
            boolean bl;
            this.outputStyleSpecifier(writeNewline);
            this.outputEventSpecifier(writeNewline);
            if (!this.isTopNode) {
                this.writeDelimiter(writeNewline);
                if (this.childrenSpecifier == null) {
                    this.write(ASEmitterTokens.NULL);
                } else {
                    this.outputChildren(this.childrenSpecifier, writeNewline);
                }
            }
            boolean bl2 = bl = this.parent != null && this.parent.propertySpecifiers.indexOf(this) == this.parent.propertySpecifiers.size() - 1;
            if (!bl && !this.isTopNode) {
                this.writeDelimiter(writeNewline);
            }
        }
        return this.sb.toString();
    }

    private void outputChildren(MXMLDescriptorSpecifier children, boolean writeNewline) {
        this.write(ASEmitterTokens.SQUARE_OPEN.getToken());
        if (writeNewline) {
            this.indentPush();
            this.writeNewline();
        }
        this.write(children.output(writeNewline));
        if (writeNewline) {
            this.indentPop();
            this.writeNewline();
        }
        this.write(ASEmitterTokens.SQUARE_CLOSE.getToken());
    }

    public String outputStateDescriptors(boolean writeNewLine) {
        for (MXMLDescriptorSpecifier md : this.propertySpecifiers) {
            this.write(ASEmitterTokens.SQUARE_OPEN);
            this.write(md.output(writeNewLine));
            this.write(ASEmitterTokens.SQUARE_CLOSE);
            this.writeNewline(ASEmitterTokens.COMMA);
        }
        return this.sb.toString();
    }
}

