/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class BrokerInfo {
    private final String clusterName;
    private final String brokerName;
    private final AtomicLong brokerIdCount;
    private final HashMap<String, Long> brokerIdTable;

    public BrokerInfo(String clusterName, String brokerName) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerIdCount = new AtomicLong(1L);
        this.brokerIdTable = new HashMap();
    }

    public void removeBrokerAddress(String address) {
        this.brokerIdTable.remove(address);
    }

    public long newBrokerId() {
        return this.brokerIdCount.incrementAndGet();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void addBroker(String address, Long brokerId) {
        this.brokerIdTable.put(address, brokerId);
    }

    public boolean isBrokerExist(String address) {
        return this.brokerIdTable.containsKey(address);
    }

    public Set<String> getAllBroker() {
        return new HashSet<String>(this.brokerIdTable.keySet());
    }

    public HashMap<String, Long> getBrokerIdTable() {
        return new HashMap<String, Long>(this.brokerIdTable);
    }

    public Long getBrokerId(String address) {
        if (this.brokerIdTable.containsKey(address)) {
            return this.brokerIdTable.get(address);
        }
        return -1L;
    }
}

