/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction.jdbc;

import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.transaction.TransactionRecord;
import org.apache.rocketmq.broker.transaction.TransactionStore;
import org.apache.rocketmq.broker.transaction.jdbc.JDBCTransactionStoreConfig;
import org.apache.rocketmq.common.MixAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTransactionStore
implements TransactionStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private final JDBCTransactionStoreConfig jdbcTransactionStoreConfig;
    private Connection connection;
    private AtomicLong totalRecordsValue = new AtomicLong(0L);

    public JDBCTransactionStore(JDBCTransactionStoreConfig jdbcTransactionStoreConfig) {
        this.jdbcTransactionStoreConfig = jdbcTransactionStoreConfig;
    }

    @Override
    public boolean open() {
        if (this.loadDriver()) {
            Properties props = new Properties();
            props.put("user", this.jdbcTransactionStoreConfig.getJdbcUser());
            props.put("password", this.jdbcTransactionStoreConfig.getJdbcPassword());
            try {
                this.connection = DriverManager.getConnection(this.jdbcTransactionStoreConfig.getJdbcURL(), props);
                this.connection.setAutoCommit(false);
                if (!this.computeTotalRecords()) {
                    return this.createDB();
                }
                return true;
            }
            catch (SQLException e) {
                log.info("Create JDBC Connection Exception", (Throwable)e);
            }
        }
        return false;
    }

    private boolean loadDriver() {
        try {
            Class.forName(this.jdbcTransactionStoreConfig.getJdbcDriverClass()).newInstance();
            log.info("Loaded the appropriate driver, {}", (Object)this.jdbcTransactionStoreConfig.getJdbcDriverClass());
            return true;
        }
        catch (Exception e) {
            log.info("Loaded the appropriate driver Exception", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeTotalRecords() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("select count(offset) as total from t_transaction");
            if (!resultSet.next()) {
                log.warn("computeTotalRecords ResultSet is empty");
                boolean bl = false;
                return bl;
            }
            this.totalRecordsValue.set(resultSet.getLong(1));
        }
        catch (Exception e) {
            log.warn("computeTotalRecords Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDB() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            String sql = this.createTableSql();
            log.info("createDB SQL:\n {}", (Object)sql);
            statement.execute(sql);
            this.connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("createDB Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn("Close statement exception", (Throwable)e);
                }
            }
        }
    }

    private String createTableSql() {
        URL resource = JDBCTransactionStore.class.getClassLoader().getResource("transaction.sql");
        String fileContent = MixAll.file2String((URL)resource);
        return fileContent;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(List<TransactionRecord> trs) {
        Statement statement = null;
        try {
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement("insert into t_transaction values (?, ?)");
            for (TransactionRecord tr : trs) {
                statement.setLong(1, tr.getOffset());
                statement.setString(2, tr.getProducerGroup());
                statement.addBatch();
            }
            int[] executeBatch = statement.executeBatch();
            this.connection.commit();
            this.totalRecordsValue.addAndGet(this.updatedRows(executeBatch));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("createDB Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn("Close statement exception", (Throwable)e);
                }
            }
        }
    }

    private long updatedRows(int[] rows) {
        long res = 0L;
        for (int i : rows) {
            res += (long)i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(List<Long> pks) {
        Statement statement = null;
        try {
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement("DELETE FROM t_transaction WHERE offset = ?");
            for (long pk : pks) {
                statement.setLong(1, pk);
                statement.addBatch();
            }
            int[] executeBatch = statement.executeBatch();
            this.connection.commit();
        }
        catch (Exception e) {
            log.warn("createDB Exception", (Throwable)e);
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<TransactionRecord> traverse(long pk, int nums) {
        return null;
    }

    @Override
    public long totalRecords() {
        return this.totalRecordsValue.get();
    }

    @Override
    public long minPK() {
        return 0L;
    }

    @Override
    public long maxPK() {
        return 0L;
    }
}

