/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.apache.log4j.Logger;
import sun.security.pkcs11.SunPKCS11;

public class RangerSafenetKeySecure
implements RangerKMSMKI {
    static final Logger logger = Logger.getLogger(RangerSafenetKeySecure.class);
    private final String alias;
    private final KeyStore myStore;
    private final String adp;
    private final Provider provider;
    private static final String MK_ALGO = "AES";
    private final int mkSize;
    private static final int MK_KeySize = 256;
    private String pkcs11CfgFilePath = null;
    private static final String CFGFILEPATH = "ranger.kms.keysecure.sunpkcs11.cfg.filepath";
    private static final String MK_KEYSIZE = "ranger.kms.keysecure.masterkey.size";
    private static final String ALIAS = "ranger.kms.keysecure.masterkey.name";
    private static final String KEYSECURE_LOGIN = "ranger.kms.keysecure.login";

    public RangerSafenetKeySecure(Configuration conf) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.mkSize = conf.getInt(MK_KEYSIZE, 256);
        this.alias = conf.get(ALIAS, "RANGERMK");
        this.adp = conf.get(KEYSECURE_LOGIN);
        this.pkcs11CfgFilePath = conf.get(CFGFILEPATH);
        try {
            this.provider = new SunPKCS11(this.pkcs11CfgFilePath);
            Security.addProvider(this.provider);
            this.myStore = KeyStore.getInstance("PKCS11", this.provider);
            if (this.myStore != null) {
                this.myStore.load(null, this.adp.toCharArray());
            } else {
                logger.error((Object)"Safenet Keysecure not found. Please verify the Ranger KMS Safenet Keysecure configuration setup.");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("Unexpected NoSuchAlgorithmException while loading keystore : " + nsae.getMessage());
        }
        catch (CertificateException e) {
            throw new CertificateException("Unexpected CertificateException while loading keystore : " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Unexpected IOException while loading keystore : " + e.getMessage());
        }
    }

    @Override
    public boolean generateMasterKey(String password) {
        if (this.myStore != null) {
            KeyGenerator keyGen = null;
            SecretKey aesKey = null;
            try {
                boolean result = this.myStore.containsAlias(this.alias);
                if (!result) {
                    keyGen = KeyGenerator.getInstance(MK_ALGO, this.provider);
                    keyGen.init(this.mkSize);
                    aesKey = keyGen.generateKey();
                    this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                    return true;
                }
                return true;
            }
            catch (Exception e) {
                logger.error((Object)("generateMasterKey : Exception during Ranger Master Key Generation - " + e));
                return false;
            }
        }
        return false;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        if (this.myStore != null) {
            try {
                SecretKey key;
                boolean result = this.myStore.containsAlias(this.alias);
                if (result && (key = (SecretKey)this.myStore.getKey(this.alias, password.toCharArray())) != null) {
                    return Base64.encode(key.getEncoded());
                }
            }
            catch (Exception e) {
                logger.error((Object)("getMasterKey : Exception searching for Ranger Master Key - " + e.getMessage()));
            }
        }
        return null;
    }

    public boolean setMasterKey(String password, byte[] key, Configuration conf) {
        if (this.myStore != null) {
            try {
                SecretKeySpec aesKey = new SecretKeySpec(key, MK_ALGO);
                this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                return true;
            }
            catch (Exception e) {
                logger.error((Object)("setMasterKey : Exception while setting Master Key - " + e.getMessage()));
            }
        }
        return false;
    }
}

