/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.apache.log4j.Logger;
import org.apache.ranger.entity.XXRangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.kms.dao.RangerMasterKeyDao;
import org.apache.ranger.plugin.util.XMLUtils;

public class RangerMasterKey
implements RangerKMSMKI {
    private static final Logger logger = Logger.getLogger(RangerMasterKey.class);
    private static final String DEFAULT_MK_CIPHER = "AES";
    private static final int DEFAULT_MK_KeySize = 256;
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final String DEFAULT_SALT = "abcdefghijklmnopqrstuvwxyz01234567890";
    private static final String DEFAULT_CRYPT_ALGO = "PBEWithMD5AndTripleDES";
    private static final String DEFAULT_MD_ALGO = "MD5";
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private static String password = null;
    public static final String DBKS_SITE_XML = "dbks-site.xml";
    private static Properties serverConfigProperties = new Properties();
    public static String MK_CIPHER;
    public static Integer MK_KeySize;
    public static Integer SALT_SIZE;
    public static String SALT;
    public static String PBE_ALGO;
    public static String MD_ALGO;
    public static Integer ITERATION_COUNT;
    public static String paddingString;
    private DaoManager daoManager;

    public RangerMasterKey() {
    }

    public RangerMasterKey(DaoManager daoManager) {
        this.daoManager = daoManager;
    }

    protected static String getConfig(String key, String defaultValue) {
        String value = serverConfigProperties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        if (value == null || value.trim().isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    protected static int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = serverConfigProperties.getProperty(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            logger.warn((Object)(retStr + " can't be parsed to int. Reason: " + err.toString()));
        }
        return ret;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.getMasterKey()");
        }
        logger.info((Object)"Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"<== RangerMasterKey.getMasterKey()");
            }
            return this.decryptMasterKey(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    public SecretKey getMasterSecretKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.getMasterSecretKey()");
        }
        logger.info((Object)"Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"<== RangerMasterKey.getMasterSecretKey()");
            }
            return this.decryptMasterKeySK(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.init()");
        }
        XMLUtils.loadConfig((String)DBKS_SITE_XML, (Map)serverConfigProperties);
        MK_CIPHER = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.cipher", DEFAULT_MK_CIPHER);
        MK_KeySize = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.size", 256);
        SALT_SIZE = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.salt.size", 8);
        SALT = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.salt", DEFAULT_SALT);
        PBE_ALGO = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.encryption.algorithm", DEFAULT_CRYPT_ALGO);
        MD_ALGO = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.md.algorithm", DEFAULT_MD_ALGO);
        ITERATION_COUNT = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.iteration.count", 1000);
        paddingString = Joiner.on((String)",").skipNulls().join((Object)MK_CIPHER, (Object)MK_KeySize, new Object[]{SALT_SIZE, PBE_ALGO, MD_ALGO, ITERATION_COUNT, SALT});
    }

    @Override
    public boolean generateMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.generateMasterKey()");
        }
        logger.info((Object)"Generating Master Key...");
        this.init();
        String encryptedMasterKey = this.encryptMasterKey(password);
        String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey, this.daoManager);
        if (savedKey != null && !savedKey.trim().equals("")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Master Key Created with id = " + savedKey));
                logger.debug((Object)"<== RangerMasterKey.generateMasterKey()");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.generateMasterKey()");
        }
        return false;
    }

    public boolean generateMKFromHSMMK(String password, byte[] key) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.generateMKFromHSMMK()");
        }
        this.init();
        String encryptedMasterKey = this.encryptMasterKey(password, key);
        String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey, this.daoManager);
        if (savedKey != null && !savedKey.trim().equals("")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Master Key Created with id = " + savedKey));
                logger.debug((Object)"<== RangerMasterKey.generateMKFromHSMMK()");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.generateMKFromHSMMK()");
        }
        return false;
    }

    private String decryptMasterKey(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.decryptMasterKey()");
            logger.debug((Object)"Decrypting Master Key...");
        }
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password);
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        SecretKey masterKeyFromDB = this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.decryptMasterKey()");
        }
        return Base64.encode(masterKeyFromDB.getEncoded());
    }

    public static void getPasswordParam(String paddedEncryptedPwd) {
        String[] encryptedPwd = null;
        if (paddedEncryptedPwd != null && paddedEncryptedPwd.contains(",")) {
            encryptedPwd = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)paddedEncryptedPwd)).toArray(new String[0]);
        }
        if (encryptedPwd != null && encryptedPwd.length >= 7) {
            int index = 0;
            MK_CIPHER = encryptedPwd[index];
            MK_KeySize = Integer.parseInt(encryptedPwd[++index]);
            SALT_SIZE = Integer.parseInt(encryptedPwd[++index]);
            PBE_ALGO = encryptedPwd[++index];
            MD_ALGO = encryptedPwd[++index];
            ITERATION_COUNT = Integer.parseInt(encryptedPwd[++index]);
            SALT = encryptedPwd[++index];
            password = encryptedPwd[++index];
        } else {
            MK_CIPHER = DEFAULT_MK_CIPHER;
            MK_KeySize = 256;
            SALT_SIZE = 8;
            PBE_ALGO = DEFAULT_CRYPT_ALGO;
            MD_ALGO = DEFAULT_MD_ALGO;
            SALT = password = paddedEncryptedPwd;
            if (password != null) {
                ITERATION_COUNT = password.toCharArray().length + 1;
            }
        }
    }

    public boolean generateMKFromKeySecureMK(String password, byte[] key) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.generateMKFromKeySecureMK()");
        }
        this.init();
        String encryptedMasterKey = this.encryptMasterKey(password, key);
        String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey, this.daoManager);
        if (savedKey != null && !savedKey.trim().equals("")) {
            logger.debug((Object)("Master Key Created with id = " + savedKey));
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.generateMKFromKeySecureMK()");
        }
        return false;
    }

    private SecretKey decryptMasterKeySK(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.decryptMasterKeySK()");
        }
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password);
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.decryptMasterKeySK()");
        }
        return this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
    }

    private List getEncryptedMK() throws Base64DecodingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.getEncryptedMK()");
        }
        try {
            if (this.daoManager != null) {
                ArrayList<Object> ret = new ArrayList<Object>();
                RangerMasterKeyDao rangerKMSDao = new RangerMasterKeyDao(this.daoManager);
                List lstRangerMasterKey = rangerKMSDao.getAll();
                if (lstRangerMasterKey.size() < 1) {
                    throw new Exception("No Master Key exists");
                }
                if (lstRangerMasterKey.size() > 1) {
                    throw new Exception("More than one Master Key exists");
                }
                XXRangerMasterKey rangerMasterKey = (XXRangerMasterKey)rangerKMSDao.getById(((XXRangerMasterKey)lstRangerMasterKey.get(0)).getId());
                String masterKeyStr = rangerMasterKey.getMasterKey();
                if (masterKeyStr.contains(",")) {
                    RangerMasterKey.getPasswordParam(masterKeyStr);
                    ret.add(Base64.decode(password));
                    ret.add(masterKeyStr);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"<== RangerMasterKey.getEncryptedMK()");
                    }
                    return ret;
                }
                ret.add(Base64.decode(masterKeyStr));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"<== RangerMasterKey.getEncryptedMK()");
                }
                return ret;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to Retrieving Master Key from database!!! or ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.getEncryptedMK()");
        }
        return null;
    }

    private String saveEncryptedMK(String encryptedMasterKey, DaoManager daoManager) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.saveEncryptedMK()");
        }
        XXRangerMasterKey xxRangerMasterKey = new XXRangerMasterKey();
        xxRangerMasterKey.setCipher(MK_CIPHER);
        xxRangerMasterKey.setBitLength(MK_KeySize);
        xxRangerMasterKey.setMasterKey(encryptedMasterKey);
        try {
            RangerMasterKeyDao rangerKMSDao;
            Long l;
            if (daoManager != null && (l = (rangerKMSDao = new RangerMasterKeyDao(daoManager)).getAllCount()) < 1L) {
                XXRangerMasterKey rangerMasterKey = rangerKMSDao.create(xxRangerMasterKey);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"<== RangerMasterKey.saveEncryptedMK()");
                }
                return rangerMasterKey.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while saving master key in Database!!! ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.saveEncryptedMK()");
        }
        return null;
    }

    private String encryptMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.encryptMasterKey()");
        }
        Key secretKey = this.generateMasterKey();
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password);
        byte[] masterKeyToDB = this.encryptKey(secretKey.getEncoded(), pbeKeySpec);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.encryptMasterKey()");
        }
        return Base64.encode(masterKeyToDB);
    }

    private String encryptMasterKey(String password, byte[] secretKey) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.encryptMasterKey()");
        }
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password);
        byte[] masterKeyToDB = this.encryptKey(secretKey, pbeKeySpec);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerMasterKey.encryptMasterKey()");
        }
        return Base64.encode(masterKeyToDB);
    }

    private Key generateMasterKey() throws NoSuchAlgorithmException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.generateMasterKey()");
        }
        KeyGenerator kg = KeyGenerator.getInstance(MK_CIPHER);
        kg.init(MK_KeySize);
        return kg.generateKey();
    }

    private PBEKeySpec getPBEParameterSpec(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.getPBEParameterSpec()");
        }
        MessageDigest md = MessageDigest.getInstance(MD_ALGO);
        byte[] saltGen = md.digest(SALT.getBytes());
        byte[] salt = new byte[SALT_SIZE.intValue()];
        System.arraycopy(saltGen, 0, salt, 0, SALT_SIZE);
        return new PBEKeySpec(password.toCharArray(), salt, ITERATION_COUNT);
    }

    private byte[] encryptKey(byte[] data, PBEKeySpec keyspec) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.encryptKey()");
        }
        SecretKey key = this.getPasswordKey(keyspec);
        if (keyspec.getSalt() != null) {
            PBEParameterSpec paramSpec = new PBEParameterSpec(keyspec.getSalt(), keyspec.getIterationCount());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            c.init(1, (Key)key, paramSpec);
            return c.doFinal(data);
        }
        return null;
    }

    private SecretKey getPasswordKey(PBEKeySpec keyspec) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerMasterKey.getPasswordKey()");
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBE_ALGO);
        return factory.generateSecret(keyspec);
    }

    private byte[] decryptKey(byte[] encrypted, PBEKeySpec keyspec) throws Throwable {
        SecretKey key = this.getPasswordKey(keyspec);
        if (keyspec.getSalt() != null) {
            PBEParameterSpec paramSpec = new PBEParameterSpec(keyspec.getSalt(), keyspec.getIterationCount());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            c.init(2, (Key)key, paramSpec);
            return c.doFinal(encrypted);
        }
        return null;
    }

    private SecretKey getMasterKeyFromBytes(byte[] keyData) throws Throwable {
        return new SecretKeySpec(keyData, MK_CIPHER);
    }

    public Map<String, String> getPropertiesWithPrefix(Properties props, String prefix) {
        HashMap<String, String> prefixedProperties = new HashMap<String, String>();
        if (props != null && prefix != null) {
            for (String key : props.stringPropertyNames()) {
                if (key == null) continue;
                String val = props.getProperty(key);
                if (!key.startsWith(prefix) || (key = key.substring(prefix.length())) == null) continue;
                prefixedProperties.put(key, val);
            }
        }
        return prefixedProperties;
    }

    static {
        MK_KeySize = 0;
        SALT_SIZE = 0;
        ITERATION_COUNT = 0;
    }
}

