/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.util.Date;
import java.util.Set;
import javax.security.auth.Subject;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Alter$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Map;

public class RangerKafkaAuthorizer
implements Authorizer {
    private static final Log logger = LogFactory.getLog(RangerKafkaAuthorizer.class);
    public static final String KEY_TOPIC = "topic";
    public static final String KEY_CLUSTER = "cluster";
    public static final String KEY_CONSUMER_GROUP = "consumer_group";
    public static final String ACCESS_TYPE_READ = "consume";
    public static final String ACCESS_TYPE_WRITE = "publish";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_DELETE = "delete";
    public static final String ACCESS_TYPE_CONFIGURE = "configure";
    public static final String ACCESS_TYPE_DESCRIBE = "describe";
    public static final String ACCESS_TYPE_KAFKA_ADMIN = "kafka_admin";
    private static volatile RangerBasePlugin rangerPlugin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void configure(java.util.Map<String, ?> configs) {
        RangerBasePlugin me = rangerPlugin;
        if (me == null) {
            Class<RangerKafkaAuthorizer> clazz = RangerKafkaAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.kafka.authorizer.RangerKafkaAuthorizer.class
            me = rangerPlugin;
            if (me == null) {
                try {
                    LoginManager loginManager = LoginManager.acquireLoginManager((LoginType)LoginType.SERVER, (boolean)true, configs);
                    Subject subject = loginManager.subject();
                    UserGroupInformation ugi = MiscUtil.createUGIFromSubject((Subject)subject);
                    if (ugi != null) {
                        MiscUtil.setUGILoginUser((UserGroupInformation)ugi, (Subject)subject);
                    }
                    logger.info((Object)("LoginUser=" + MiscUtil.getUGILoginUser()));
                }
                catch (Throwable t) {
                    logger.error((Object)"Error getting principal.", t);
                }
                me = rangerPlugin = new RangerBasePlugin("kafka", "kafka");
            }
            // MONITOREXIT : clazz
        }
        logger.info((Object)"Calling plugin.init()");
        rangerPlugin.init();
        RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler();
        rangerPlugin.setResultProcessor((RangerAccessResultProcessor)auditHandler);
    }

    public void close() {
        logger.info((Object)"close() called on authorizer.");
        try {
            if (rangerPlugin != null) {
                rangerPlugin.cleanup();
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error closing RangerPlugin.", t);
        }
    }

    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        if (rangerPlugin == null) {
            MiscUtil.logErrorMessageByInterval((Log)logger, (String)"Authorizer is still not initialized");
            return false;
        }
        if (resource.resourceType().equals(Group$.MODULE$)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"If resource type is consumer group, then we allow it by default!  Returning true");
            }
            return true;
        }
        String userName = null;
        if (session.principal() != null) {
            userName = session.principal().getName();
            userName = StringUtils.substringBefore((String)userName, (String)"/");
            userName = StringUtils.substringBefore((String)userName, (String)"@");
        }
        Set userGroups = MiscUtil.getGroupsForRequestUser(userName);
        String ip = session.clientAddress().getHostAddress();
        if (StringUtils.isNotEmpty((String)ip) && ip.charAt(0) == '/') {
            ip = ip.substring(1);
        }
        Date eventTime = new Date();
        String accessType = this.mapToRangerAccessType(operation);
        boolean validationFailed = false;
        String validationStr = "";
        if (accessType == null) {
            if (MiscUtil.logErrorMessageByInterval((Log)logger, (String)("Unsupported access type. operation=" + operation))) {
                logger.fatal((Object)("Unsupported access type. session=" + session + ", operation=" + operation + ", resource=" + resource));
            }
            validationFailed = true;
            validationStr = validationStr + "Unsupported access type. operation=" + operation;
        }
        String action = accessType;
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        rangerRequest.setUser(userName);
        rangerRequest.setUserGroups(userGroups);
        rangerRequest.setClientIPAddress(ip);
        rangerRequest.setAccessTime(eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(action);
        rangerRequest.setRequestData(resource.name());
        if (resource.resourceType().equals(Topic$.MODULE$)) {
            rangerResource.setValue(KEY_TOPIC, resource.name());
        } else if (!resource.resourceType().equals(Cluster$.MODULE$)) {
            if (resource.resourceType().equals(Group$.MODULE$)) {
                rangerResource.setValue(KEY_CONSUMER_GROUP, resource.name());
            } else {
                logger.fatal((Object)("Unsupported resourceType=" + resource.resourceType()));
                validationFailed = true;
            }
        }
        boolean returnValue = false;
        if (validationFailed) {
            MiscUtil.logErrorMessageByInterval((Log)logger, (String)(validationStr + ", request=" + rangerRequest));
        } else {
            try {
                RangerAccessResult result = rangerPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest);
                if (result == null) {
                    logger.error((Object)"Ranger Plugin returned null. Returning false");
                } else {
                    returnValue = result.getIsAllowed();
                }
            }
            catch (Throwable t) {
                logger.error((Object)("Error while calling isAccessAllowed(). request=" + rangerRequest), t);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rangerRequest=" + rangerRequest + ", return=" + returnValue));
        }
        return returnValue;
    }

    public void addAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        logger.error((Object)"addAcls(Set<Acl>, Resource) is not supported by Ranger for Kafka");
    }

    public boolean removeAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        logger.error((Object)"removeAcls(Set<Acl>, Resource) is not supported by Ranger for Kafka");
        return false;
    }

    public boolean removeAcls(Resource resource) {
        logger.error((Object)"removeAcls(Resource) is not supported by Ranger for Kafka");
        return false;
    }

    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        HashSet aclList = new HashSet();
        logger.error((Object)"getAcls(Resource) is not supported by Ranger for Kafka");
        return aclList;
    }

    public Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        HashMap aclList = new HashMap();
        logger.error((Object)"getAcls(KafkaPrincipal) is not supported by Ranger for Kafka");
        return aclList;
    }

    public Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        HashMap aclList = new HashMap();
        logger.error((Object)"getAcls() is not supported by Ranger for Kafka");
        return aclList;
    }

    private String mapToRangerAccessType(Operation operation) {
        if (operation.equals(Read$.MODULE$)) {
            return ACCESS_TYPE_READ;
        }
        if (operation.equals(Write$.MODULE$)) {
            return ACCESS_TYPE_WRITE;
        }
        if (operation.equals(Alter$.MODULE$)) {
            return ACCESS_TYPE_CONFIGURE;
        }
        if (operation.equals(Describe$.MODULE$)) {
            return ACCESS_TYPE_DESCRIBE;
        }
        if (operation.equals(ClusterAction$.MODULE$)) {
            return ACCESS_TYPE_KAFKA_ADMIN;
        }
        if (operation.equals(Create$.MODULE$)) {
            return ACCESS_TYPE_CREATE;
        }
        if (operation.equals(Delete$.MODULE$)) {
            return ACCESS_TYPE_DELETE;
        }
        return null;
    }
}

